package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import odata.msgraph.client.beta.entity.ImportedWindowsAutopilotDeviceIdentityUpload;
import odata.msgraph.client.beta.entity.collection.request.ImportedWindowsAutopilotDeviceIdentityCollectionRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

@JsonIgnoreType
public class ImportedWindowsAutopilotDeviceIdentityUploadRequest extends EntityRequest<ImportedWindowsAutopilotDeviceIdentityUpload> {

    public ImportedWindowsAutopilotDeviceIdentityUploadRequest(ContextPath contextPath) {
        super(ImportedWindowsAutopilotDeviceIdentityUpload.class, contextPath, SchemaInfo.INSTANCE);
    }

    public ImportedWindowsAutopilotDeviceIdentityCollectionRequest deviceIdentities() {
        return new ImportedWindowsAutopilotDeviceIdentityCollectionRequest(
                        contextPath.addSegment("deviceIdentities"));
    }

    public ImportedWindowsAutopilotDeviceIdentityRequest deviceIdentities(String id) {
        return new ImportedWindowsAutopilotDeviceIdentityRequest(contextPath.addSegment("deviceIdentities").addKeys(new NameValue(id.toString())));
    }

}
