package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import odata.msgraph.client.beta.entity.IdentityProtectionRoot;
import odata.msgraph.client.beta.entity.collection.request.RiskDetectionCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.RiskyUserCollectionRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

@JsonIgnoreType
public class IdentityProtectionRootRequest extends EntityRequest<IdentityProtectionRoot> {

    public IdentityProtectionRootRequest(ContextPath contextPath) {
        super(IdentityProtectionRoot.class, contextPath, SchemaInfo.INSTANCE);
    }

    public RiskDetectionCollectionRequest riskDetections() {
        return new RiskDetectionCollectionRequest(
                        contextPath.addSegment("riskDetections"));
    }

    public RiskDetectionRequest riskDetections(String id) {
        return new RiskDetectionRequest(contextPath.addSegment("riskDetections").addKeys(new NameValue(id.toString())));
    }

    public RiskyUserCollectionRequest riskyUsers() {
        return new RiskyUserCollectionRequest(
                        contextPath.addSegment("riskyUsers"));
    }

    public RiskyUserRequest riskyUsers(String id) {
        return new RiskyUserRequest(contextPath.addSegment("riskyUsers").addKeys(new NameValue(id.toString())));
    }

}
