package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;

import odata.msgraph.client.beta.entity.IdentityGovernance;
import odata.msgraph.client.beta.schema.SchemaInfo;

@JsonIgnoreType
public class IdentityGovernanceRequest extends EntityRequest<IdentityGovernance> {

    public IdentityGovernanceRequest(ContextPath contextPath) {
        super(IdentityGovernance.class, contextPath, SchemaInfo.INSTANCE);
    }

    public AccessReviewSetRequest accessReviews() {
        return new AccessReviewSetRequest(contextPath.addSegment("accessReviews"));
    }

    public EntitlementManagementRequest entitlementManagement() {
        return new EntitlementManagementRequest(contextPath.addSegment("entitlementManagement"));
    }

}
