package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import odata.msgraph.client.beta.entity.IdentityContainer;
import odata.msgraph.client.beta.entity.collection.request.IdentityUserFlowCollectionRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

@JsonIgnoreType
public class IdentityContainerRequest extends EntityRequest<IdentityContainer> {

    public IdentityContainerRequest(ContextPath contextPath) {
        super(IdentityContainer.class, contextPath, SchemaInfo.INSTANCE);
    }

    public ConditionalAccessRootRequest conditionalAccess() {
        return new ConditionalAccessRootRequest(contextPath.addSegment("conditionalAccess"));
    }

    public IdentityUserFlowCollectionRequest userFlows() {
        return new IdentityUserFlowCollectionRequest(
                        contextPath.addSegment("userFlows"));
    }

    public IdentityUserFlowRequest userFlows(String id) {
        return new IdentityUserFlowRequest(contextPath.addSegment("userFlows").addKeys(new NameValue(id.toString())));
    }

}
