package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.guavamini.Preconditions;
import com.github.davidmoten.odata.client.ActionRequestNoReturn;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.util.List;
import java.util.Map;

import odata.msgraph.client.beta.complex.GroupPolicyUploadedLanguageFile;
import odata.msgraph.client.beta.entity.GroupPolicyUploadedDefinitionFile;
import odata.msgraph.client.beta.entity.collection.request.GroupPolicyOperationCollectionRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

@JsonIgnoreType
public class GroupPolicyUploadedDefinitionFileRequest extends EntityRequest<GroupPolicyUploadedDefinitionFile> {

    public GroupPolicyUploadedDefinitionFileRequest(ContextPath contextPath) {
        super(GroupPolicyUploadedDefinitionFile.class, contextPath, SchemaInfo.INSTANCE);
    }

    public GroupPolicyOperationCollectionRequest groupPolicyOperations() {
        return new GroupPolicyOperationCollectionRequest(
                        contextPath.addSegment("groupPolicyOperations"));
    }

    public GroupPolicyOperationRequest groupPolicyOperations(String id) {
        return new GroupPolicyOperationRequest(contextPath.addSegment("groupPolicyOperations").addKeys(new NameValue(id.toString())));
    }

    @Action(name = "addLanguageFiles")
    @JsonIgnore
    public ActionRequestNoReturn addLanguageFiles(List<GroupPolicyUploadedLanguageFile> groupPolicyUploadedLanguageFiles) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("groupPolicyUploadedLanguageFiles", "Collection(microsoft.graph.groupPolicyUploadedLanguageFile)", groupPolicyUploadedLanguageFiles)
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.addLanguageFiles"), _parameters);
    }

    @Action(name = "removeLanguageFiles")
    @JsonIgnore
    public ActionRequestNoReturn removeLanguageFiles(List<GroupPolicyUploadedLanguageFile> groupPolicyUploadedLanguageFiles) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("groupPolicyUploadedLanguageFiles", "Collection(microsoft.graph.groupPolicyUploadedLanguageFile)", groupPolicyUploadedLanguageFiles)
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.removeLanguageFiles"), _parameters);
    }

    @Action(name = "updateLanguageFiles")
    @JsonIgnore
    public ActionRequestNoReturn updateLanguageFiles(List<GroupPolicyUploadedLanguageFile> groupPolicyUploadedLanguageFiles) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("groupPolicyUploadedLanguageFiles", "Collection(microsoft.graph.groupPolicyUploadedLanguageFile)", groupPolicyUploadedLanguageFiles)
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.updateLanguageFiles"), _parameters);
    }

    @Action(name = "uploadNewVersion")
    @JsonIgnore
    public ActionRequestNoReturn uploadNewVersion(byte[] content, List<GroupPolicyUploadedLanguageFile> groupPolicyUploadedLanguageFiles) {
        Preconditions.checkNotNull(content, "content cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("content", "Edm.Binary", content)
            .put("groupPolicyUploadedLanguageFiles", "Collection(microsoft.graph.groupPolicyUploadedLanguageFile)", groupPolicyUploadedLanguageFiles)
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.uploadNewVersion"), _parameters);
    }

    @Action(name = "remove")
    @JsonIgnore
    public ActionRequestNoReturn remove() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.remove"), _parameters);
    }

}
