package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;

import odata.msgraph.client.beta.entity.GroupPolicyPresentationValue;
import odata.msgraph.client.beta.schema.SchemaInfo;

@JsonIgnoreType
public class GroupPolicyPresentationValueRequest extends EntityRequest<GroupPolicyPresentationValue> {

    public GroupPolicyPresentationValueRequest(ContextPath contextPath) {
        super(GroupPolicyPresentationValue.class, contextPath, SchemaInfo.INSTANCE);
    }

    public GroupPolicyDefinitionValueRequest definitionValue() {
        return new GroupPolicyDefinitionValueRequest(contextPath.addSegment("definitionValue"));
    }

    public GroupPolicyPresentationRequest presentation() {
        return new GroupPolicyPresentationRequest(contextPath.addSegment("presentation"));
    }

}
