package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import odata.msgraph.client.beta.entity.GroupPolicyMigrationReport;
import odata.msgraph.client.beta.entity.collection.request.GroupPolicySettingMappingCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.UnsupportedGroupPolicyExtensionCollectionRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

@JsonIgnoreType
public class GroupPolicyMigrationReportRequest extends EntityRequest<GroupPolicyMigrationReport> {

    public GroupPolicyMigrationReportRequest(ContextPath contextPath) {
        super(GroupPolicyMigrationReport.class, contextPath, SchemaInfo.INSTANCE);
    }

    public GroupPolicySettingMappingCollectionRequest groupPolicySettingMappings() {
        return new GroupPolicySettingMappingCollectionRequest(
                        contextPath.addSegment("groupPolicySettingMappings"));
    }

    public GroupPolicySettingMappingRequest groupPolicySettingMappings(String id) {
        return new GroupPolicySettingMappingRequest(contextPath.addSegment("groupPolicySettingMappings").addKeys(new NameValue(id.toString())));
    }

    public UnsupportedGroupPolicyExtensionCollectionRequest unsupportedGroupPolicyExtensions() {
        return new UnsupportedGroupPolicyExtensionCollectionRequest(
                        contextPath.addSegment("unsupportedGroupPolicyExtensions"));
    }

    public UnsupportedGroupPolicyExtensionRequest unsupportedGroupPolicyExtensions(String id) {
        return new UnsupportedGroupPolicyExtensionRequest(contextPath.addSegment("unsupportedGroupPolicyExtensions").addKeys(new NameValue(id.toString())));
    }

}
