package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import odata.msgraph.client.beta.entity.GroupPolicyDefinition;
import odata.msgraph.client.beta.entity.collection.request.GroupPolicyPresentationCollectionRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

@JsonIgnoreType
public class GroupPolicyDefinitionRequest extends EntityRequest<GroupPolicyDefinition> {

    public GroupPolicyDefinitionRequest(ContextPath contextPath) {
        super(GroupPolicyDefinition.class, contextPath, SchemaInfo.INSTANCE);
    }

    public GroupPolicyDefinitionFileRequest definitionFile() {
        return new GroupPolicyDefinitionFileRequest(contextPath.addSegment("definitionFile"));
    }

    public GroupPolicyCategoryRequest category() {
        return new GroupPolicyCategoryRequest(contextPath.addSegment("category"));
    }

    public GroupPolicyPresentationCollectionRequest presentations() {
        return new GroupPolicyPresentationCollectionRequest(
                        contextPath.addSegment("presentations"));
    }

    public GroupPolicyPresentationRequest presentations(String id) {
        return new GroupPolicyPresentationRequest(contextPath.addSegment("presentations").addKeys(new NameValue(id.toString())));
    }

}
