package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import odata.msgraph.client.beta.entity.GroupPolicyDefinitionFile;
import odata.msgraph.client.beta.entity.collection.request.GroupPolicyDefinitionCollectionRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

@JsonIgnoreType
public class GroupPolicyDefinitionFileRequest extends EntityRequest<GroupPolicyDefinitionFile> {

    public GroupPolicyDefinitionFileRequest(ContextPath contextPath) {
        super(GroupPolicyDefinitionFile.class, contextPath, SchemaInfo.INSTANCE);
    }

    public GroupPolicyDefinitionCollectionRequest definitions() {
        return new GroupPolicyDefinitionCollectionRequest(
                        contextPath.addSegment("definitions"));
    }

    public GroupPolicyDefinitionRequest definitions(String id) {
        return new GroupPolicyDefinitionRequest(contextPath.addSegment("definitions").addKeys(new NameValue(id.toString())));
    }

}
