package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ActionRequestNoReturn;
import com.github.davidmoten.odata.client.CollectionPageNonEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.util.List;
import java.util.Map;

import odata.msgraph.client.beta.entity.GroupPolicyConfiguration;
import odata.msgraph.client.beta.entity.GroupPolicyConfigurationAssignment;
import odata.msgraph.client.beta.entity.GroupPolicyDefinitionValue;
import odata.msgraph.client.beta.entity.collection.request.GroupPolicyConfigurationAssignmentCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.GroupPolicyDefinitionValueCollectionRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

@JsonIgnoreType
public class GroupPolicyConfigurationRequest extends EntityRequest<GroupPolicyConfiguration> {

    public GroupPolicyConfigurationRequest(ContextPath contextPath) {
        super(GroupPolicyConfiguration.class, contextPath, SchemaInfo.INSTANCE);
    }

    public GroupPolicyDefinitionValueCollectionRequest definitionValues() {
        return new GroupPolicyDefinitionValueCollectionRequest(
                        contextPath.addSegment("definitionValues"));
    }

    public GroupPolicyDefinitionValueRequest definitionValues(String id) {
        return new GroupPolicyDefinitionValueRequest(contextPath.addSegment("definitionValues").addKeys(new NameValue(id.toString())));
    }

    public GroupPolicyConfigurationAssignmentCollectionRequest assignments() {
        return new GroupPolicyConfigurationAssignmentCollectionRequest(
                        contextPath.addSegment("assignments"));
    }

    public GroupPolicyConfigurationAssignmentRequest assignments(String id) {
        return new GroupPolicyConfigurationAssignmentRequest(contextPath.addSegment("assignments").addKeys(new NameValue(id.toString())));
    }

    @Action(name = "assign")
    @JsonIgnore
    public CollectionPageNonEntityRequest<GroupPolicyConfigurationAssignment> assign(List<GroupPolicyConfigurationAssignment> assignments) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("assignments", "Collection(microsoft.graph.groupPolicyConfigurationAssignment)", assignments)
            .build();
        return CollectionPageNonEntityRequest.forAction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.assign"), GroupPolicyConfigurationAssignment.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

    @Action(name = "updateDefinitionValues")
    @JsonIgnore
    public ActionRequestNoReturn updateDefinitionValues(List<GroupPolicyDefinitionValue> added, List<GroupPolicyDefinitionValue> updated, List<String> deletedIds) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("added", "Collection(microsoft.graph.groupPolicyDefinitionValue)", added)
            .put("updated", "Collection(microsoft.graph.groupPolicyDefinitionValue)", updated)
            .put("deletedIds", "Collection(Edm.String)", Checks.checkIsAscii(deletedIds))
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.updateDefinitionValues"), _parameters);
    }

}
