package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import odata.msgraph.client.beta.entity.GroupPolicyCategory;
import odata.msgraph.client.beta.entity.collection.request.GroupPolicyCategoryCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.GroupPolicyDefinitionCollectionRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

@JsonIgnoreType
public class GroupPolicyCategoryRequest extends EntityRequest<GroupPolicyCategory> {

    public GroupPolicyCategoryRequest(ContextPath contextPath) {
        super(GroupPolicyCategory.class, contextPath, SchemaInfo.INSTANCE);
    }

    public GroupPolicyCategoryRequest parent() {
        return new GroupPolicyCategoryRequest(contextPath.addSegment("parent"));
    }

    public GroupPolicyCategoryCollectionRequest children() {
        return new GroupPolicyCategoryCollectionRequest(
                        contextPath.addSegment("children"));
    }

    public GroupPolicyCategoryRequest children(String id) {
        return new GroupPolicyCategoryRequest(contextPath.addSegment("children").addKeys(new NameValue(id.toString())));
    }

    public GroupPolicyDefinitionCollectionRequest definitions() {
        return new GroupPolicyDefinitionCollectionRequest(
                        contextPath.addSegment("definitions"));
    }

    public GroupPolicyDefinitionRequest definitions(String id) {
        return new GroupPolicyDefinitionRequest(contextPath.addSegment("definitions").addKeys(new NameValue(id.toString())));
    }

    public GroupPolicyDefinitionFileRequest definitionFile() {
        return new GroupPolicyDefinitionFileRequest(contextPath.addSegment("definitionFile"));
    }

}
