package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.guavamini.Preconditions;
import com.github.davidmoten.odata.client.ActionRequestReturningNonCollection;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.util.Map;

import odata.msgraph.client.beta.entity.GroupLifecyclePolicy;
import odata.msgraph.client.beta.schema.SchemaInfo;

@JsonIgnoreType
public class GroupLifecyclePolicyRequest extends EntityRequest<GroupLifecyclePolicy> {

    public GroupLifecyclePolicyRequest(ContextPath contextPath) {
        super(GroupLifecyclePolicy.class, contextPath, SchemaInfo.INSTANCE);
    }

    @Action(name = "addGroup")
    @JsonIgnore
    public ActionRequestReturningNonCollection<Boolean> addGroup(String groupId) {
        Preconditions.checkNotNull(groupId, "groupId cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("groupId", "Edm.String", Checks.checkIsAscii(groupId))
            .build();
        return new ActionRequestReturningNonCollection<Boolean>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.addGroup"), Boolean.class, _parameters, com.github.davidmoten.odata.client.internal.EdmSchemaInfo.INSTANCE);
    }

    @Action(name = "removeGroup")
    @JsonIgnore
    public ActionRequestReturningNonCollection<Boolean> removeGroup(String groupId) {
        Preconditions.checkNotNull(groupId, "groupId cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("groupId", "Edm.String", Checks.checkIsAscii(groupId))
            .build();
        return new ActionRequestReturningNonCollection<Boolean>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.removeGroup"), Boolean.class, _parameters, com.github.davidmoten.odata.client.internal.EdmSchemaInfo.INSTANCE);
    }

}
