package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;

import odata.msgraph.client.beta.entity.GovernanceRoleSetting;
import odata.msgraph.client.beta.schema.SchemaInfo;

@JsonIgnoreType
public class GovernanceRoleSettingRequest extends EntityRequest<GovernanceRoleSetting> {

    public GovernanceRoleSettingRequest(ContextPath contextPath) {
        super(GovernanceRoleSetting.class, contextPath, SchemaInfo.INSTANCE);
    }

    public GovernanceRoleDefinitionRequest roleDefinition() {
        return new GovernanceRoleDefinitionRequest(contextPath.addSegment("roleDefinition"));
    }

    public GovernanceResourceRequest resource() {
        return new GovernanceResourceRequest(contextPath.addSegment("resource"));
    }

}
