package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;

import odata.msgraph.client.beta.entity.GovernanceRoleDefinition;
import odata.msgraph.client.beta.schema.SchemaInfo;

@JsonIgnoreType
public class GovernanceRoleDefinitionRequest extends EntityRequest<GovernanceRoleDefinition> {

    public GovernanceRoleDefinitionRequest(ContextPath contextPath) {
        super(GovernanceRoleDefinition.class, contextPath, SchemaInfo.INSTANCE);
    }

    public GovernanceResourceRequest resource() {
        return new GovernanceResourceRequest(contextPath.addSegment("resource"));
    }

    public GovernanceRoleSettingRequest roleSetting() {
        return new GovernanceRoleSettingRequest(contextPath.addSegment("roleSetting"));
    }

}
