package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;

import odata.msgraph.client.beta.entity.GovernanceRoleAssignment;
import odata.msgraph.client.beta.schema.SchemaInfo;

@JsonIgnoreType
public class GovernanceRoleAssignmentRequest extends EntityRequest<GovernanceRoleAssignment> {

    public GovernanceRoleAssignmentRequest(ContextPath contextPath) {
        super(GovernanceRoleAssignment.class, contextPath, SchemaInfo.INSTANCE);
    }

    public GovernanceResourceRequest resource() {
        return new GovernanceResourceRequest(contextPath.addSegment("resource"));
    }

    public GovernanceRoleDefinitionRequest roleDefinition() {
        return new GovernanceRoleDefinitionRequest(contextPath.addSegment("roleDefinition"));
    }

    public GovernanceSubjectRequest subject() {
        return new GovernanceSubjectRequest(contextPath.addSegment("subject"));
    }

    public GovernanceRoleAssignmentRequest linkedEligibleRoleAssignment() {
        return new GovernanceRoleAssignmentRequest(contextPath.addSegment("linkedEligibleRoleAssignment"));
    }

}
