package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import odata.msgraph.client.beta.entity.Financials;
import odata.msgraph.client.beta.entity.collection.request.CompanyCollectionRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

@JsonIgnoreType
public class FinancialsRequest extends EntityRequest<Financials> {

    public FinancialsRequest(ContextPath contextPath) {
        super(Financials.class, contextPath, SchemaInfo.INSTANCE);
    }

    public CompanyCollectionRequest companies() {
        return new CompanyCollectionRequest(
                        contextPath.addSegment("companies"));
    }

    public CompanyRequest companies(String id) {
        return new CompanyRequest(contextPath.addSegment("companies").addKeys(new NameValue(id.toString())));
    }

}
