package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import odata.msgraph.client.beta.entity.External;
import odata.msgraph.client.beta.entity.collection.request.ExternalConnectionCollectionRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

@JsonIgnoreType
public class ExternalRequest extends EntityRequest<External> {

    public ExternalRequest(ContextPath contextPath) {
        super(External.class, contextPath, SchemaInfo.INSTANCE);
    }

    public ExternalConnectionCollectionRequest connections() {
        return new ExternalConnectionCollectionRequest(
                        contextPath.addSegment("connections"));
    }

    public ExternalConnectionRequest connections(String id) {
        return new ExternalConnectionRequest(contextPath.addSegment("connections").addKeys(new NameValue(id.toString())));
    }

}
