package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import odata.msgraph.client.beta.entity.ExternalConnection;
import odata.msgraph.client.beta.entity.collection.request.ConnectionOperationCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.ExternalItemCollectionRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

@JsonIgnoreType
public class ExternalConnectionRequest extends EntityRequest<ExternalConnection> {

    public ExternalConnectionRequest(ContextPath contextPath) {
        super(ExternalConnection.class, contextPath, SchemaInfo.INSTANCE);
    }

    public SchemaRequest schema() {
        return new SchemaRequest(contextPath.addSegment("schema"));
    }

    public ExternalItemCollectionRequest items() {
        return new ExternalItemCollectionRequest(
                        contextPath.addSegment("items"));
    }

    public ExternalItemRequest items(String id) {
        return new ExternalItemRequest(contextPath.addSegment("items").addKeys(new NameValue(id.toString())));
    }

    public ConnectionOperationCollectionRequest operations() {
        return new ConnectionOperationCollectionRequest(
                        contextPath.addSegment("operations"));
    }

    public ConnectionOperationRequest operations(String id) {
        return new ConnectionOperationRequest(contextPath.addSegment("operations").addKeys(new NameValue(id.toString())));
    }

}
