package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import odata.msgraph.client.beta.entity.ExactMatchLookupJob;
import odata.msgraph.client.beta.entity.collection.request.LookupResultRowCollectionRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

@JsonIgnoreType
public class ExactMatchLookupJobRequest extends EntityRequest<ExactMatchLookupJob> {

    public ExactMatchLookupJobRequest(ContextPath contextPath) {
        super(ExactMatchLookupJob.class, contextPath, SchemaInfo.INSTANCE);
    }

    public LookupResultRowCollectionRequest matchingRows() {
        return new LookupResultRowCollectionRequest(
                        contextPath.addSegment("matchingRows"));
    }

    public LookupResultRowRequest matchingRows(String id) {
        return new LookupResultRowRequest(contextPath.addSegment("matchingRows").addKeys(new NameValue(id.toString())));
    }

}
