package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.CollectionPageNonEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.util.List;
import java.util.Map;

import odata.msgraph.client.beta.entity.ExactMatchDataStore;
import odata.msgraph.client.beta.entity.collection.request.ExactMatchSessionCollectionRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

@JsonIgnoreType
public class ExactMatchDataStoreRequest extends EntityRequest<ExactMatchDataStore> {

    public ExactMatchDataStoreRequest(ContextPath contextPath) {
        super(ExactMatchDataStore.class, contextPath, SchemaInfo.INSTANCE);
    }

    public ExactMatchSessionCollectionRequest sessions() {
        return new ExactMatchSessionCollectionRequest(
                        contextPath.addSegment("sessions"));
    }

    public ExactMatchSessionRequest sessions(String id) {
        return new ExactMatchSessionRequest(contextPath.addSegment("sessions").addKeys(new NameValue(id.toString())));
    }

    @Action(name = "lookup")
    @JsonIgnore
    public CollectionPageNonEntityRequest<String> lookup(String key, List<String> values, List<String> resultColumnNames) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("key", "Edm.String", Checks.checkIsAscii(key))
            .put("values", "Collection(Edm.String)", Checks.checkIsAscii(values))
            .put("resultColumnNames", "Collection(Edm.String)", Checks.checkIsAscii(resultColumnNames))
            .build();
        return CollectionPageNonEntityRequest.forAction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.lookup"), String.class, _parameters, com.github.davidmoten.odata.client.internal.EdmSchemaInfo.INSTANCE);
    }

}
