package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.guavamini.Preconditions;
import com.github.davidmoten.odata.client.ActionRequestNoReturn;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.util.List;
import java.util.Map;

import odata.msgraph.client.beta.complex.DateTimeTimeZone;
import odata.msgraph.client.beta.complex.Recipient;
import odata.msgraph.client.beta.complex.TimeSlot;
import odata.msgraph.client.beta.entity.Event;
import odata.msgraph.client.beta.entity.collection.request.AttachmentCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.EventCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.ExtensionCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.MultiValueLegacyExtendedPropertyCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.SingleValueLegacyExtendedPropertyCollectionRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

@JsonIgnoreType
public class EventRequest extends EntityRequest<Event> {

    public EventRequest(ContextPath contextPath) {
        super(Event.class, contextPath, SchemaInfo.INSTANCE);
    }

    public AttachmentCollectionRequest attachments() {
        return new AttachmentCollectionRequest(
                        contextPath.addSegment("attachments"));
    }

    public AttachmentRequest attachments(String id) {
        return new AttachmentRequest(contextPath.addSegment("attachments").addKeys(new NameValue(id.toString())));
    }

    public SingleValueLegacyExtendedPropertyCollectionRequest singleValueExtendedProperties() {
        return new SingleValueLegacyExtendedPropertyCollectionRequest(
                        contextPath.addSegment("singleValueExtendedProperties"));
    }

    public SingleValueLegacyExtendedPropertyRequest singleValueExtendedProperties(String id) {
        return new SingleValueLegacyExtendedPropertyRequest(contextPath.addSegment("singleValueExtendedProperties").addKeys(new NameValue(id.toString())));
    }

    public MultiValueLegacyExtendedPropertyCollectionRequest multiValueExtendedProperties() {
        return new MultiValueLegacyExtendedPropertyCollectionRequest(
                        contextPath.addSegment("multiValueExtendedProperties"));
    }

    public MultiValueLegacyExtendedPropertyRequest multiValueExtendedProperties(String id) {
        return new MultiValueLegacyExtendedPropertyRequest(contextPath.addSegment("multiValueExtendedProperties").addKeys(new NameValue(id.toString())));
    }

    public CalendarRequest calendar() {
        return new CalendarRequest(contextPath.addSegment("calendar"));
    }

    public EventCollectionRequest instances() {
        return new EventCollectionRequest(
                        contextPath.addSegment("instances"));
    }

    public EventRequest instances(String id) {
        return new EventRequest(contextPath.addSegment("instances").addKeys(new NameValue(id.toString())));
    }

    public ExtensionCollectionRequest extensions() {
        return new ExtensionCollectionRequest(
                        contextPath.addSegment("extensions"));
    }

    public ExtensionRequest extensions(String id) {
        return new ExtensionRequest(contextPath.addSegment("extensions").addKeys(new NameValue(id.toString())));
    }

    @Action(name = "dismissReminder")
    @JsonIgnore
    public ActionRequestNoReturn dismissReminder() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.dismissReminder"), _parameters);
    }

    @Action(name = "snoozeReminder")
    @JsonIgnore
    public ActionRequestNoReturn snoozeReminder(DateTimeTimeZone newReminderTime) {
        Preconditions.checkNotNull(newReminderTime, "newReminderTime cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("NewReminderTime", "microsoft.graph.dateTimeTimeZone", newReminderTime)
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.snoozeReminder"), _parameters);
    }

    @Action(name = "forward")
    @JsonIgnore
    public ActionRequestNoReturn forward(List<Recipient> toRecipients, String comment) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("ToRecipients", "Collection(microsoft.graph.recipient)", toRecipients)
            .put("Comment", "Edm.String", Checks.checkIsAscii(comment))
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.forward"), _parameters);
    }

    @Action(name = "accept")
    @JsonIgnore
    public ActionRequestNoReturn accept(Boolean sendResponse, String comment) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("SendResponse", "Edm.Boolean", sendResponse)
            .put("Comment", "Edm.String", Checks.checkIsAscii(comment))
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.accept"), _parameters);
    }

    @Action(name = "decline")
    @JsonIgnore
    public ActionRequestNoReturn decline(TimeSlot proposedNewTime, Boolean sendResponse, String comment) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("ProposedNewTime", "microsoft.graph.timeSlot", proposedNewTime)
            .put("SendResponse", "Edm.Boolean", sendResponse)
            .put("Comment", "Edm.String", Checks.checkIsAscii(comment))
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.decline"), _parameters);
    }

    @Action(name = "tentativelyAccept")
    @JsonIgnore
    public ActionRequestNoReturn tentativelyAccept(TimeSlot proposedNewTime, Boolean sendResponse, String comment) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("ProposedNewTime", "microsoft.graph.timeSlot", proposedNewTime)
            .put("SendResponse", "Edm.Boolean", sendResponse)
            .put("Comment", "Edm.String", Checks.checkIsAscii(comment))
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.tentativelyAccept"), _parameters);
    }

    @Action(name = "cancel")
    @JsonIgnore
    public ActionRequestNoReturn cancel(String comment) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("Comment", "Edm.String", Checks.checkIsAscii(comment))
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.cancel"), _parameters);
    }

}
