package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ActionRequestNoReturn;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.util.Map;

import odata.msgraph.client.beta.complex.TimeSlot;
import odata.msgraph.client.beta.entity.EventMessageRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

@JsonIgnoreType
public class EventMessageRequestRequest extends EntityRequest<EventMessageRequest> {

    public EventMessageRequestRequest(ContextPath contextPath) {
        super(EventMessageRequest.class, contextPath, SchemaInfo.INSTANCE);
    }

    @Action(name = "accept")
    @JsonIgnore
    public ActionRequestNoReturn accept(Boolean sendResponse, String comment) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("SendResponse", "Edm.Boolean", sendResponse)
            .put("Comment", "Edm.String", Checks.checkIsAscii(comment))
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.accept"), _parameters);
    }

    @Action(name = "decline")
    @JsonIgnore
    public ActionRequestNoReturn decline(TimeSlot proposedNewTime, Boolean sendResponse, String comment) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("ProposedNewTime", "microsoft.graph.timeSlot", proposedNewTime)
            .put("SendResponse", "Edm.Boolean", sendResponse)
            .put("Comment", "Edm.String", Checks.checkIsAscii(comment))
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.decline"), _parameters);
    }

    @Action(name = "tentativelyAccept")
    @JsonIgnore
    public ActionRequestNoReturn tentativelyAccept(TimeSlot proposedNewTime, Boolean sendResponse, String comment) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("ProposedNewTime", "microsoft.graph.timeSlot", proposedNewTime)
            .put("SendResponse", "Edm.Boolean", sendResponse)
            .put("Comment", "Edm.String", Checks.checkIsAscii(comment))
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.tentativelyAccept"), _parameters);
    }

}
