package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import odata.msgraph.client.beta.entity.EntitlementManagement;
import odata.msgraph.client.beta.entity.collection.request.AccessPackageAssignmentCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.AccessPackageAssignmentPolicyCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.AccessPackageAssignmentRequestCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.AccessPackageAssignmentResourceRoleCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.AccessPackageCatalogCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.AccessPackageCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.AccessPackageResourceCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.AccessPackageResourceRequestCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.AccessPackageResourceRoleScopeCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.ConnectedOrganizationCollectionRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

@JsonIgnoreType
public class EntitlementManagementRequest extends EntityRequest<EntitlementManagement> {

    public EntitlementManagementRequest(ContextPath contextPath) {
        super(EntitlementManagement.class, contextPath, SchemaInfo.INSTANCE);
    }

    public AccessPackageCatalogCollectionRequest accessPackageCatalogs() {
        return new AccessPackageCatalogCollectionRequest(
                        contextPath.addSegment("accessPackageCatalogs"));
    }

    public AccessPackageCatalogRequest accessPackageCatalogs(String id) {
        return new AccessPackageCatalogRequest(contextPath.addSegment("accessPackageCatalogs").addKeys(new NameValue(id.toString())));
    }

    public AccessPackageResourceCollectionRequest accessPackageResources() {
        return new AccessPackageResourceCollectionRequest(
                        contextPath.addSegment("accessPackageResources"));
    }

    public AccessPackageResourceRequest accessPackageResources(String id) {
        return new AccessPackageResourceRequest(contextPath.addSegment("accessPackageResources").addKeys(new NameValue(id.toString())));
    }

    public AccessPackageResourceRequestCollectionRequest accessPackageResourceRequests() {
        return new AccessPackageResourceRequestCollectionRequest(
                        contextPath.addSegment("accessPackageResourceRequests"));
    }

    public AccessPackageResourceRequestRequest accessPackageResourceRequests(String id) {
        return new AccessPackageResourceRequestRequest(contextPath.addSegment("accessPackageResourceRequests").addKeys(new NameValue(id.toString())));
    }

    public AccessPackageResourceRoleScopeCollectionRequest accessPackageResourceRoleScopes() {
        return new AccessPackageResourceRoleScopeCollectionRequest(
                        contextPath.addSegment("accessPackageResourceRoleScopes"));
    }

    public AccessPackageResourceRoleScopeRequest accessPackageResourceRoleScopes(String id) {
        return new AccessPackageResourceRoleScopeRequest(contextPath.addSegment("accessPackageResourceRoleScopes").addKeys(new NameValue(id.toString())));
    }

    public AccessPackageCollectionRequest accessPackages() {
        return new AccessPackageCollectionRequest(
                        contextPath.addSegment("accessPackages"));
    }

    public AccessPackageRequest accessPackages(String id) {
        return new AccessPackageRequest(contextPath.addSegment("accessPackages").addKeys(new NameValue(id.toString())));
    }

    public AccessPackageAssignmentPolicyCollectionRequest accessPackageAssignmentPolicies() {
        return new AccessPackageAssignmentPolicyCollectionRequest(
                        contextPath.addSegment("accessPackageAssignmentPolicies"));
    }

    public AccessPackageAssignmentPolicyRequest accessPackageAssignmentPolicies(String id) {
        return new AccessPackageAssignmentPolicyRequest(contextPath.addSegment("accessPackageAssignmentPolicies").addKeys(new NameValue(id.toString())));
    }

    public AccessPackageAssignmentCollectionRequest accessPackageAssignments() {
        return new AccessPackageAssignmentCollectionRequest(
                        contextPath.addSegment("accessPackageAssignments"));
    }

    public AccessPackageAssignmentRequest accessPackageAssignments(String id) {
        return new AccessPackageAssignmentRequest(contextPath.addSegment("accessPackageAssignments").addKeys(new NameValue(id.toString())));
    }

    public AccessPackageAssignmentRequestCollectionRequest accessPackageAssignmentRequests() {
        return new AccessPackageAssignmentRequestCollectionRequest(
                        contextPath.addSegment("accessPackageAssignmentRequests"));
    }

    public AccessPackageAssignmentRequestRequest accessPackageAssignmentRequests(String id) {
        return new AccessPackageAssignmentRequestRequest(contextPath.addSegment("accessPackageAssignmentRequests").addKeys(new NameValue(id.toString())));
    }

    public AccessPackageAssignmentResourceRoleCollectionRequest accessPackageAssignmentResourceRoles() {
        return new AccessPackageAssignmentResourceRoleCollectionRequest(
                        contextPath.addSegment("accessPackageAssignmentResourceRoles"));
    }

    public AccessPackageAssignmentResourceRoleRequest accessPackageAssignmentResourceRoles(String id) {
        return new AccessPackageAssignmentResourceRoleRequest(contextPath.addSegment("accessPackageAssignmentResourceRoles").addKeys(new NameValue(id.toString())));
    }

    public EntitlementManagementSettingsRequest settings() {
        return new EntitlementManagementSettingsRequest(contextPath.addSegment("settings"));
    }

    public ConnectedOrganizationCollectionRequest connectedOrganizations() {
        return new ConnectedOrganizationCollectionRequest(
                        contextPath.addSegment("connectedOrganizations"));
    }

    public ConnectedOrganizationRequest connectedOrganizations(String id) {
        return new ConnectedOrganizationRequest(contextPath.addSegment("connectedOrganizations").addKeys(new NameValue(id.toString())));
    }

}
