package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import odata.msgraph.client.beta.entity.EducationUser;
import odata.msgraph.client.beta.entity.collection.request.EducationAssignmentCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.EducationClassCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.EducationRubricCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.EducationSchoolCollectionRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

@JsonIgnoreType
public class EducationUserRequest extends EntityRequest<EducationUser> {

    public EducationUserRequest(ContextPath contextPath) {
        super(EducationUser.class, contextPath, SchemaInfo.INSTANCE);
    }

    public EducationAssignmentCollectionRequest assignments() {
        return new EducationAssignmentCollectionRequest(
                        contextPath.addSegment("assignments"));
    }

    public EducationAssignmentRequest assignments(String id) {
        return new EducationAssignmentRequest(contextPath.addSegment("assignments").addKeys(new NameValue(id.toString())));
    }

    public EducationRubricCollectionRequest rubrics() {
        return new EducationRubricCollectionRequest(
                        contextPath.addSegment("rubrics"));
    }

    public EducationRubricRequest rubrics(String id) {
        return new EducationRubricRequest(contextPath.addSegment("rubrics").addKeys(new NameValue(id.toString())));
    }

    public EducationClassCollectionRequest classes() {
        return new EducationClassCollectionRequest(
                        contextPath.addSegment("classes"));
    }

    public EducationClassRequest classes(String id) {
        return new EducationClassRequest(contextPath.addSegment("classes").addKeys(new NameValue(id.toString())));
    }

    public EducationClassCollectionRequest taughtClasses() {
        return new EducationClassCollectionRequest(
                        contextPath.addSegment("taughtClasses"));
    }

    public EducationClassRequest taughtClasses(String id) {
        return new EducationClassRequest(contextPath.addSegment("taughtClasses").addKeys(new NameValue(id.toString())));
    }

    public EducationSchoolCollectionRequest schools() {
        return new EducationSchoolCollectionRequest(
                        contextPath.addSegment("schools"));
    }

    public EducationSchoolRequest schools(String id) {
        return new EducationSchoolRequest(contextPath.addSegment("schools").addKeys(new NameValue(id.toString())));
    }

    public UserRequest user() {
        return new UserRequest(contextPath.addSegment("user"));
    }

}
