package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ActionRequestNoReturn;
import com.github.davidmoten.odata.client.CollectionPageNonEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.FunctionRequestReturningNonCollection;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.annotation.Function;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.util.Map;

import odata.msgraph.client.beta.complex.EducationFileSynchronizationVerificationMessage;
import odata.msgraph.client.beta.entity.EducationSynchronizationProfile;
import odata.msgraph.client.beta.entity.collection.request.EducationSynchronizationErrorCollectionRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

@JsonIgnoreType
public class EducationSynchronizationProfileRequest extends EntityRequest<EducationSynchronizationProfile> {

    public EducationSynchronizationProfileRequest(ContextPath contextPath) {
        super(EducationSynchronizationProfile.class, contextPath, SchemaInfo.INSTANCE);
    }

    public EducationSynchronizationErrorCollectionRequest errors() {
        return new EducationSynchronizationErrorCollectionRequest(
                        contextPath.addSegment("errors"));
    }

    public EducationSynchronizationErrorRequest errors(String id) {
        return new EducationSynchronizationErrorRequest(contextPath.addSegment("errors").addKeys(new NameValue(id.toString())));
    }

    public EducationSynchronizationProfileStatusRequest profileStatus() {
        return new EducationSynchronizationProfileStatusRequest(contextPath.addSegment("profileStatus"));
    }

    @Action(name = "resume")
    @JsonIgnore
    public ActionRequestNoReturn resume() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.resume"), _parameters);
    }

    @Action(name = "pause")
    @JsonIgnore
    public ActionRequestNoReturn pause() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.pause"), _parameters);
    }

    @Action(name = "reset")
    @JsonIgnore
    public ActionRequestNoReturn reset() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.reset"), _parameters);
    }

    @Action(name = "start")
    @JsonIgnore
    public CollectionPageNonEntityRequest<EducationFileSynchronizationVerificationMessage> start() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return CollectionPageNonEntityRequest.forAction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.start"), EducationFileSynchronizationVerificationMessage.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

    @Function(name = "uploadUrl")
    @JsonIgnore
    public FunctionRequestReturningNonCollection<String> uploadUrl() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new FunctionRequestReturningNonCollection<String>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.uploadUrl"), String.class, _parameters, com.github.davidmoten.odata.client.internal.EdmSchemaInfo.INSTANCE);
    }

}
