package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ActionRequestReturningNonCollectionUnwrapped;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.util.Map;

import odata.msgraph.client.beta.entity.EducationSubmission;
import odata.msgraph.client.beta.entity.collection.request.EducationOutcomeCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.EducationSubmissionResourceCollectionRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

@JsonIgnoreType
public class EducationSubmissionRequest extends EntityRequest<EducationSubmission> {

    public EducationSubmissionRequest(ContextPath contextPath) {
        super(EducationSubmission.class, contextPath, SchemaInfo.INSTANCE);
    }

    public EducationSubmissionResourceCollectionRequest resources() {
        return new EducationSubmissionResourceCollectionRequest(
                        contextPath.addSegment("resources"));
    }

    public EducationSubmissionResourceRequest resources(String id) {
        return new EducationSubmissionResourceRequest(contextPath.addSegment("resources").addKeys(new NameValue(id.toString())));
    }

    public EducationSubmissionResourceCollectionRequest submittedResources() {
        return new EducationSubmissionResourceCollectionRequest(
                        contextPath.addSegment("submittedResources"));
    }

    public EducationSubmissionResourceRequest submittedResources(String id) {
        return new EducationSubmissionResourceRequest(contextPath.addSegment("submittedResources").addKeys(new NameValue(id.toString())));
    }

    public EducationOutcomeCollectionRequest outcomes() {
        return new EducationOutcomeCollectionRequest(
                        contextPath.addSegment("outcomes"));
    }

    public EducationOutcomeRequest outcomes(String id) {
        return new EducationOutcomeRequest(contextPath.addSegment("outcomes").addKeys(new NameValue(id.toString())));
    }

    @Action(name = "return")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<EducationSubmission> return_() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestReturningNonCollectionUnwrapped<EducationSubmission>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.return"), EducationSubmission.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

    @Action(name = "submit")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<EducationSubmission> submit() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestReturningNonCollectionUnwrapped<EducationSubmission>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.submit"), EducationSubmission.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

    @Action(name = "unsubmit")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<EducationSubmission> unsubmit() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestReturningNonCollectionUnwrapped<EducationSubmission>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.unsubmit"), EducationSubmission.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

}
