package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import odata.msgraph.client.beta.entity.EducationSchool;
import odata.msgraph.client.beta.entity.collection.request.EducationClassCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.EducationUserCollectionRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

@JsonIgnoreType
public class EducationSchoolRequest extends EntityRequest<EducationSchool> {

    public EducationSchoolRequest(ContextPath contextPath) {
        super(EducationSchool.class, contextPath, SchemaInfo.INSTANCE);
    }

    public EducationClassCollectionRequest classes() {
        return new EducationClassCollectionRequest(
                        contextPath.addSegment("classes"));
    }

    public EducationClassRequest classes(String id) {
        return new EducationClassRequest(contextPath.addSegment("classes").addKeys(new NameValue(id.toString())));
    }

    public EducationUserCollectionRequest users() {
        return new EducationUserCollectionRequest(
                        contextPath.addSegment("users"));
    }

    public EducationUserRequest users(String id) {
        return new EducationUserRequest(contextPath.addSegment("users").addKeys(new NameValue(id.toString())));
    }

    public AdministrativeUnitRequest administrativeUnit() {
        return new AdministrativeUnitRequest(contextPath.addSegment("administrativeUnit"));
    }

}
