package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import odata.msgraph.client.beta.entity.EducationRoot;
import odata.msgraph.client.beta.entity.collection.request.EducationClassCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.EducationSchoolCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.EducationSynchronizationProfileCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.EducationUserCollectionRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

@JsonIgnoreType
public class EducationRootRequest extends EntityRequest<EducationRoot> {

    public EducationRootRequest(ContextPath contextPath) {
        super(EducationRoot.class, contextPath, SchemaInfo.INSTANCE);
    }

    public EducationSynchronizationProfileCollectionRequest synchronizationProfiles() {
        return new EducationSynchronizationProfileCollectionRequest(
                        contextPath.addSegment("synchronizationProfiles"));
    }

    public EducationSynchronizationProfileRequest synchronizationProfiles(String id) {
        return new EducationSynchronizationProfileRequest(contextPath.addSegment("synchronizationProfiles").addKeys(new NameValue(id.toString())));
    }

    public EducationClassCollectionRequest classes() {
        return new EducationClassCollectionRequest(
                        contextPath.addSegment("classes"));
    }

    public EducationClassRequest classes(String id) {
        return new EducationClassRequest(contextPath.addSegment("classes").addKeys(new NameValue(id.toString())));
    }

    public EducationSchoolCollectionRequest schools() {
        return new EducationSchoolCollectionRequest(
                        contextPath.addSegment("schools"));
    }

    public EducationSchoolRequest schools(String id) {
        return new EducationSchoolRequest(contextPath.addSegment("schools").addKeys(new NameValue(id.toString())));
    }

    public EducationUserCollectionRequest users() {
        return new EducationUserCollectionRequest(
                        contextPath.addSegment("users"));
    }

    public EducationUserRequest users(String id) {
        return new EducationUserRequest(contextPath.addSegment("users").addKeys(new NameValue(id.toString())));
    }

    public EducationUserRequest me() {
        return new EducationUserRequest(contextPath.addSegment("me"));
    }

}
