package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import odata.msgraph.client.beta.entity.EducationClass;
import odata.msgraph.client.beta.entity.collection.request.EducationAssignmentCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.EducationCategoryCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.EducationSchoolCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.EducationUserCollectionRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

@JsonIgnoreType
public class EducationClassRequest extends EntityRequest<EducationClass> {

    public EducationClassRequest(ContextPath contextPath) {
        super(EducationClass.class, contextPath, SchemaInfo.INSTANCE);
    }

    public EducationAssignmentCollectionRequest assignments() {
        return new EducationAssignmentCollectionRequest(
                        contextPath.addSegment("assignments"));
    }

    public EducationAssignmentRequest assignments(String id) {
        return new EducationAssignmentRequest(contextPath.addSegment("assignments").addKeys(new NameValue(id.toString())));
    }

    public EducationCategoryCollectionRequest assignmentCategories() {
        return new EducationCategoryCollectionRequest(
                        contextPath.addSegment("assignmentCategories"));
    }

    public EducationCategoryRequest assignmentCategories(String id) {
        return new EducationCategoryRequest(contextPath.addSegment("assignmentCategories").addKeys(new NameValue(id.toString())));
    }

    public EducationUserCollectionRequest members() {
        return new EducationUserCollectionRequest(
                        contextPath.addSegment("members"));
    }

    public EducationUserRequest members(String id) {
        return new EducationUserRequest(contextPath.addSegment("members").addKeys(new NameValue(id.toString())));
    }

    public EducationUserCollectionRequest teachers() {
        return new EducationUserCollectionRequest(
                        contextPath.addSegment("teachers"));
    }

    public EducationUserRequest teachers(String id) {
        return new EducationUserRequest(contextPath.addSegment("teachers").addKeys(new NameValue(id.toString())));
    }

    public EducationSchoolCollectionRequest schools() {
        return new EducationSchoolCollectionRequest(
                        contextPath.addSegment("schools"));
    }

    public EducationSchoolRequest schools(String id) {
        return new EducationSchoolRequest(contextPath.addSegment("schools").addKeys(new NameValue(id.toString())));
    }

    public GroupRequest group() {
        return new GroupRequest(contextPath.addSegment("group"));
    }

}
