package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ActionRequestReturningNonCollectionUnwrapped;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.FunctionRequestReturningNonCollection;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.annotation.Function;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.util.Map;

import odata.msgraph.client.beta.entity.EducationAssignment;
import odata.msgraph.client.beta.entity.collection.request.EducationAssignmentResourceCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.EducationCategoryCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.EducationSubmissionCollectionRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

@JsonIgnoreType
public class EducationAssignmentRequest extends EntityRequest<EducationAssignment> {

    public EducationAssignmentRequest(ContextPath contextPath) {
        super(EducationAssignment.class, contextPath, SchemaInfo.INSTANCE);
    }

    public EducationAssignmentResourceCollectionRequest resources() {
        return new EducationAssignmentResourceCollectionRequest(
                        contextPath.addSegment("resources"));
    }

    public EducationAssignmentResourceRequest resources(String id) {
        return new EducationAssignmentResourceRequest(contextPath.addSegment("resources").addKeys(new NameValue(id.toString())));
    }

    public EducationSubmissionCollectionRequest submissions() {
        return new EducationSubmissionCollectionRequest(
                        contextPath.addSegment("submissions"));
    }

    public EducationSubmissionRequest submissions(String id) {
        return new EducationSubmissionRequest(contextPath.addSegment("submissions").addKeys(new NameValue(id.toString())));
    }

    public EducationCategoryCollectionRequest categories() {
        return new EducationCategoryCollectionRequest(
                        contextPath.addSegment("categories"));
    }

    public EducationCategoryRequest categories(String id) {
        return new EducationCategoryRequest(contextPath.addSegment("categories").addKeys(new NameValue(id.toString())));
    }

    public EducationRubricRequest rubric() {
        return new EducationRubricRequest(contextPath.addSegment("rubric"));
    }

    @Action(name = "publish")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<EducationAssignment> publish() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestReturningNonCollectionUnwrapped<EducationAssignment>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.publish"), EducationAssignment.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

    @Function(name = "getResourcesFolderUrl")
    @JsonIgnore
    public FunctionRequestReturningNonCollection<String> getResourcesFolderUrl() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new FunctionRequestReturningNonCollection<String>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getResourcesFolderUrl"), String.class, _parameters, com.github.davidmoten.odata.client.internal.EdmSchemaInfo.INSTANCE);
    }

}
