package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import odata.msgraph.client.beta.entity.Ediscovery;
import odata.msgraph.client.beta.entity.collection.request.EdiscoveryCaseCollectionRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

@JsonIgnoreType
public class EdiscoveryRequest extends EntityRequest<Ediscovery> {

    public EdiscoveryRequest(ContextPath contextPath) {
        super(Ediscovery.class, contextPath, SchemaInfo.INSTANCE);
    }

    public EdiscoveryCaseCollectionRequest cases() {
        return new EdiscoveryCaseCollectionRequest(
                        contextPath.addSegment("cases"));
    }

    public EdiscoveryCaseRequest cases(String id) {
        return new EdiscoveryCaseRequest(contextPath.addSegment("cases").addKeys(new NameValue(id.toString())));
    }

}
