package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import odata.msgraph.client.beta.entity.EdiscoveryCase;
import odata.msgraph.client.beta.entity.collection.request.ReviewSetCollectionRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

@JsonIgnoreType
public class EdiscoveryCaseRequest extends EntityRequest<EdiscoveryCase> {

    public EdiscoveryCaseRequest(ContextPath contextPath) {
        super(EdiscoveryCase.class, contextPath, SchemaInfo.INSTANCE);
    }

    public ReviewSetCollectionRequest reviewSets() {
        return new ReviewSetCollectionRequest(
                        contextPath.addSegment("reviewSets"));
    }

    public ReviewSetRequest reviewSets(String id) {
        return new ReviewSetRequest(contextPath.addSegment("reviewSets").addKeys(new NameValue(id.toString())));
    }

}
