package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.guavamini.Preconditions;
import com.github.davidmoten.odata.client.CollectionPageNonEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.annotation.Function;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.util.Map;

import odata.msgraph.client.beta.entity.Drive;
import odata.msgraph.client.beta.entity.DriveItem;
import odata.msgraph.client.beta.entity.collection.request.DriveItemCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.ItemActivityOLDCollectionRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

@JsonIgnoreType
public class DriveRequest extends EntityRequest<Drive> {

    public DriveRequest(ContextPath contextPath) {
        super(Drive.class, contextPath, SchemaInfo.INSTANCE);
    }

    public ItemActivityOLDCollectionRequest activities() {
        return new ItemActivityOLDCollectionRequest(
                        contextPath.addSegment("activities"));
    }

    public ItemActivityOLDRequest activities(String id) {
        return new ItemActivityOLDRequest(contextPath.addSegment("activities").addKeys(new NameValue(id.toString())));
    }

    public DriveItemCollectionRequest bundles() {
        return new DriveItemCollectionRequest(
                        contextPath.addSegment("bundles"));
    }

    public DriveItemRequest bundles(String id) {
        return new DriveItemRequest(contextPath.addSegment("bundles").addKeys(new NameValue(id.toString())));
    }

    public DriveItemCollectionRequest following() {
        return new DriveItemCollectionRequest(
                        contextPath.addSegment("following"));
    }

    public DriveItemRequest following(String id) {
        return new DriveItemRequest(contextPath.addSegment("following").addKeys(new NameValue(id.toString())));
    }

    public DriveItemCollectionRequest items() {
        return new DriveItemCollectionRequest(
                        contextPath.addSegment("items"));
    }

    public DriveItemRequest items(String id) {
        return new DriveItemRequest(contextPath.addSegment("items").addKeys(new NameValue(id.toString())));
    }

    public ListRequest list() {
        return new ListRequest(contextPath.addSegment("list"));
    }

    public DriveItemRequest root() {
        return new DriveItemRequest(contextPath.addSegment("root"));
    }

    public DriveItemCollectionRequest special() {
        return new DriveItemCollectionRequest(
                        contextPath.addSegment("special"));
    }

    public DriveItemRequest special(String id) {
        return new DriveItemRequest(contextPath.addSegment("special").addKeys(new NameValue(id.toString())));
    }

    @Function(name = "recent")
    @JsonIgnore
    public CollectionPageNonEntityRequest<DriveItem> recent() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return CollectionPageNonEntityRequest.forAction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.recent"), DriveItem.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

    @Function(name = "search")
    @JsonIgnore
    public CollectionPageNonEntityRequest<DriveItem> search(String q) {
        Preconditions.checkNotNull(q, "q cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("q", "Edm.String", Checks.checkIsAscii(q))
            .build();
        return CollectionPageNonEntityRequest.forAction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.search"), DriveItem.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

    @Function(name = "sharedWithMe")
    @JsonIgnore
    public CollectionPageNonEntityRequest<DriveItem> sharedWithMe() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return CollectionPageNonEntityRequest.forAction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.sharedWithMe"), DriveItem.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

}
