package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.guavamini.Preconditions;
import com.github.davidmoten.odata.client.ActionRequestNoReturn;
import com.github.davidmoten.odata.client.ActionRequestReturningNonCollectionUnwrapped;
import com.github.davidmoten.odata.client.CollectionPageNonEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.annotation.Function;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.time.OffsetDateTime;
import java.util.List;
import java.util.Map;

import odata.msgraph.client.beta.complex.DriveItemUploadableProperties;
import odata.msgraph.client.beta.complex.DriveRecipient;
import odata.msgraph.client.beta.complex.ItemPreviewInfo;
import odata.msgraph.client.beta.complex.ItemReference;
import odata.msgraph.client.beta.complex.UploadSession;
import odata.msgraph.client.beta.entity.DriveItem;
import odata.msgraph.client.beta.entity.ItemActivityStat;
import odata.msgraph.client.beta.entity.Permission;
import odata.msgraph.client.beta.entity.collection.request.DriveItemCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.DriveItemVersionCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.ItemActivityOLDCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.PermissionCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.SubscriptionCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.ThumbnailSetCollectionRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

@JsonIgnoreType
public class DriveItemRequest extends EntityRequest<DriveItem> {

    public DriveItemRequest(ContextPath contextPath) {
        super(DriveItem.class, contextPath, SchemaInfo.INSTANCE);
    }

    public WorkbookRequest workbook() {
        return new WorkbookRequest(contextPath.addSegment("workbook"));
    }

    public ItemActivityOLDCollectionRequest activities() {
        return new ItemActivityOLDCollectionRequest(
                        contextPath.addSegment("activities"));
    }

    public ItemActivityOLDRequest activities(String id) {
        return new ItemActivityOLDRequest(contextPath.addSegment("activities").addKeys(new NameValue(id.toString())));
    }

    public ItemAnalyticsRequest analytics() {
        return new ItemAnalyticsRequest(contextPath.addSegment("analytics"));
    }

    public DriveItemCollectionRequest children() {
        return new DriveItemCollectionRequest(
                        contextPath.addSegment("children"));
    }

    public DriveItemRequest children(String id) {
        return new DriveItemRequest(contextPath.addSegment("children").addKeys(new NameValue(id.toString())));
    }

    public ListItemRequest listItem() {
        return new ListItemRequest(contextPath.addSegment("listItem"));
    }

    public PermissionCollectionRequest permissions() {
        return new PermissionCollectionRequest(
                        contextPath.addSegment("permissions"));
    }

    public PermissionRequest permissions(String id) {
        return new PermissionRequest(contextPath.addSegment("permissions").addKeys(new NameValue(id.toString())));
    }

    public SubscriptionCollectionRequest subscriptions() {
        return new SubscriptionCollectionRequest(
                        contextPath.addSegment("subscriptions"));
    }

    public SubscriptionRequest subscriptions(String id) {
        return new SubscriptionRequest(contextPath.addSegment("subscriptions").addKeys(new NameValue(id.toString())));
    }

    public ThumbnailSetCollectionRequest thumbnails() {
        return new ThumbnailSetCollectionRequest(
                        contextPath.addSegment("thumbnails"));
    }

    public ThumbnailSetRequest thumbnails(String id) {
        return new ThumbnailSetRequest(contextPath.addSegment("thumbnails").addKeys(new NameValue(id.toString())));
    }

    public DriveItemVersionCollectionRequest versions() {
        return new DriveItemVersionCollectionRequest(
                        contextPath.addSegment("versions"));
    }

    public DriveItemVersionRequest versions(String id) {
        return new DriveItemVersionRequest(contextPath.addSegment("versions").addKeys(new NameValue(id.toString())));
    }

    @Action(name = "checkin")
    @JsonIgnore
    public ActionRequestNoReturn checkin(String checkInAs, String comment) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("checkInAs", "Edm.String", Checks.checkIsAscii(checkInAs))
            .put("comment", "Edm.String", Checks.checkIsAscii(comment))
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.checkin"), _parameters);
    }

    @Action(name = "checkout")
    @JsonIgnore
    public ActionRequestNoReturn checkout() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.checkout"), _parameters);
    }

    @Action(name = "copy")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<DriveItem> copy(String name, ItemReference parentReference) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("name", "Edm.String", Checks.checkIsAscii(name))
            .put("parentReference", "microsoft.graph.itemReference", parentReference)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<DriveItem>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.copy"), DriveItem.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

    @Action(name = "createLink")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<Permission> createLink(String type, String scope, OffsetDateTime expirationDateTime, String password, String message, List<DriveRecipient> recipients) {
        Preconditions.checkNotNull(type, "type cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("type", "Edm.String", Checks.checkIsAscii(type))
            .put("scope", "Edm.String", Checks.checkIsAscii(scope))
            .put("expirationDateTime", "Edm.DateTimeOffset", expirationDateTime)
            .put("password", "Edm.String", Checks.checkIsAscii(password))
            .put("message", "Edm.String", Checks.checkIsAscii(message))
            .put("recipients", "Collection(microsoft.graph.driveRecipient)", recipients)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<Permission>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.createLink"), Permission.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

    @Action(name = "createUploadSession")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<UploadSession> createUploadSession(DriveItemUploadableProperties item, Boolean deferCommit) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("item", "microsoft.graph.driveItemUploadableProperties", item)
            .put("deferCommit", "Edm.Boolean", deferCommit)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<UploadSession>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.createUploadSession"), UploadSession.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

    @Action(name = "follow")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<DriveItem> follow() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestReturningNonCollectionUnwrapped<DriveItem>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.follow"), DriveItem.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

    @Action(name = "unfollow")
    @JsonIgnore
    public ActionRequestNoReturn unfollow() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.unfollow"), _parameters);
    }

    @Action(name = "invite")
    @JsonIgnore
    public CollectionPageNonEntityRequest<Permission> invite(Boolean requireSignIn, List<String> roles, Boolean sendInvitation, String message, List<DriveRecipient> recipients, String expirationDateTime, String password) {
        Preconditions.checkNotNull(recipients, "recipients cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("requireSignIn", "Edm.Boolean", requireSignIn)
            .put("roles", "Collection(Edm.String)", Checks.checkIsAscii(roles))
            .put("sendInvitation", "Edm.Boolean", sendInvitation)
            .put("message", "Edm.String", Checks.checkIsAscii(message))
            .put("recipients", "Collection(microsoft.graph.driveRecipient)", recipients)
            .put("expirationDateTime", "Edm.String", Checks.checkIsAscii(expirationDateTime))
            .put("password", "Edm.String", Checks.checkIsAscii(password))
            .build();
        return CollectionPageNonEntityRequest.forAction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.invite"), Permission.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

    @Action(name = "preview")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<ItemPreviewInfo> preview(String viewer, Boolean chromeless, Boolean allowEdit, String page, Double zoom) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("viewer", "Edm.String", Checks.checkIsAscii(viewer))
            .put("chromeless", "Edm.Boolean", chromeless)
            .put("allowEdit", "Edm.Boolean", allowEdit)
            .put("page", "Edm.String", Checks.checkIsAscii(page))
            .put("zoom", "Edm.Double", zoom)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<ItemPreviewInfo>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.preview"), ItemPreviewInfo.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

    @Action(name = "restore")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<DriveItem> restore(ItemReference parentReference, String name) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("parentReference", "microsoft.graph.itemReference", parentReference)
            .put("name", "Edm.String", Checks.checkIsAscii(name))
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<DriveItem>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.restore"), DriveItem.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

    @Action(name = "validatePermission")
    @JsonIgnore
    public ActionRequestNoReturn validatePermission(String challengeToken, String password) {
        Preconditions.checkNotNull(password, "password cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("challengeToken", "Edm.String", Checks.checkIsAscii(challengeToken))
            .put("password", "Edm.String", Checks.checkIsAscii(password))
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.validatePermission"), _parameters);
    }

    @Function(name = "delta")
    @JsonIgnore
    public CollectionPageNonEntityRequest<DriveItem> delta(String token) {
        Preconditions.checkNotNull(token, "token cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("token", "Edm.String", Checks.checkIsAscii(token))
            .build();
        return CollectionPageNonEntityRequest.forAction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.delta"), DriveItem.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

    @Function(name = "delta")
    @JsonIgnore
    public CollectionPageNonEntityRequest<DriveItem> delta_Function() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return CollectionPageNonEntityRequest.forAction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.delta"), DriveItem.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

    @Function(name = "getActivitiesByInterval")
    @JsonIgnore
    public CollectionPageNonEntityRequest<ItemActivityStat> getActivitiesByInterval(String startDateTime, String endDateTime, String interval) {
        Preconditions.checkNotNull(startDateTime, "startDateTime cannot be null");
        Preconditions.checkNotNull(endDateTime, "endDateTime cannot be null");
        Preconditions.checkNotNull(interval, "interval cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("startDateTime", "Edm.String", Checks.checkIsAscii(startDateTime))
            .put("endDateTime", "Edm.String", Checks.checkIsAscii(endDateTime))
            .put("interval", "Edm.String", Checks.checkIsAscii(interval))
            .build();
        return CollectionPageNonEntityRequest.forAction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getActivitiesByInterval"), ItemActivityStat.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

    @Function(name = "search")
    @JsonIgnore
    public CollectionPageNonEntityRequest<DriveItem> search(String q) {
        Preconditions.checkNotNull(q, "q cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("q", "Edm.String", Checks.checkIsAscii(q))
            .build();
        return CollectionPageNonEntityRequest.forAction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.search"), DriveItem.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

}
