package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ActionRequestNoReturn;
import com.github.davidmoten.odata.client.ActionRequestReturningNonCollectionUnwrapped;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.util.Map;

import odata.msgraph.client.beta.entity.Domain;
import odata.msgraph.client.beta.entity.collection.request.DirectoryObjectCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.DomainDnsRecordCollectionRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

@JsonIgnoreType
public class DomainRequest extends EntityRequest<Domain> {

    public DomainRequest(ContextPath contextPath) {
        super(Domain.class, contextPath, SchemaInfo.INSTANCE);
    }

    public DomainDnsRecordCollectionRequest serviceConfigurationRecords() {
        return new DomainDnsRecordCollectionRequest(
                        contextPath.addSegment("serviceConfigurationRecords"));
    }

    public DomainDnsRecordRequest serviceConfigurationRecords(String id) {
        return new DomainDnsRecordRequest(contextPath.addSegment("serviceConfigurationRecords").addKeys(new NameValue(id.toString())));
    }

    public DomainDnsRecordCollectionRequest verificationDnsRecords() {
        return new DomainDnsRecordCollectionRequest(
                        contextPath.addSegment("verificationDnsRecords"));
    }

    public DomainDnsRecordRequest verificationDnsRecords(String id) {
        return new DomainDnsRecordRequest(contextPath.addSegment("verificationDnsRecords").addKeys(new NameValue(id.toString())));
    }

    public DirectoryObjectCollectionRequest domainNameReferences() {
        return new DirectoryObjectCollectionRequest(
                        contextPath.addSegment("domainNameReferences"));
    }

    public DirectoryObjectRequest domainNameReferences(String id) {
        return new DirectoryObjectRequest(contextPath.addSegment("domainNameReferences").addKeys(new NameValue(id.toString())));
    }

    @Action(name = "forceDelete")
    @JsonIgnore
    public ActionRequestNoReturn forceDelete(Boolean disableUserAccounts) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("disableUserAccounts", "Edm.Boolean", disableUserAccounts)
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.forceDelete"), _parameters);
    }

    @Action(name = "verify")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<Domain> verify() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestReturningNonCollectionUnwrapped<Domain>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.verify"), Domain.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

}
