package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import odata.msgraph.client.beta.entity.Document;
import odata.msgraph.client.beta.entity.collection.request.DocumentCommentCollectionRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

@JsonIgnoreType
public class DocumentRequest extends EntityRequest<Document> {

    public DocumentRequest(ContextPath contextPath) {
        super(Document.class, contextPath, SchemaInfo.INSTANCE);
    }

    public DocumentCommentCollectionRequest comments() {
        return new DocumentCommentCollectionRequest(
                        contextPath.addSegment("comments"));
    }

    public DocumentCommentRequest comments(String id) {
        return new DocumentCommentRequest(contextPath.addSegment("comments").addKeys(new NameValue(id.toString())));
    }

}
