package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import odata.msgraph.client.beta.entity.DocumentComment;
import odata.msgraph.client.beta.entity.collection.request.DocumentCommentReplyCollectionRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

@JsonIgnoreType
public class DocumentCommentRequest extends EntityRequest<DocumentComment> {

    public DocumentCommentRequest(ContextPath contextPath) {
        super(DocumentComment.class, contextPath, SchemaInfo.INSTANCE);
    }

    public DocumentCommentReplyCollectionRequest replies() {
        return new DocumentCommentReplyCollectionRequest(
                        contextPath.addSegment("replies"));
    }

    public DocumentCommentReplyRequest replies(String id) {
        return new DocumentCommentReplyRequest(contextPath.addSegment("replies").addKeys(new NameValue(id.toString())));
    }

}
