package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import odata.msgraph.client.beta.entity.DirectoryRole;
import odata.msgraph.client.beta.entity.collection.request.DirectoryObjectCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.ScopedRoleMembershipCollectionRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

@JsonIgnoreType
public class DirectoryRoleRequest extends EntityRequest<DirectoryRole> {

    public DirectoryRoleRequest(ContextPath contextPath) {
        super(DirectoryRole.class, contextPath, SchemaInfo.INSTANCE);
    }

    public DirectoryObjectCollectionRequest members() {
        return new DirectoryObjectCollectionRequest(
                        contextPath.addSegment("members"));
    }

    public DirectoryObjectRequest members(String id) {
        return new DirectoryObjectRequest(contextPath.addSegment("members").addKeys(new NameValue(id.toString())));
    }

    public ScopedRoleMembershipCollectionRequest scopedMembers() {
        return new ScopedRoleMembershipCollectionRequest(
                        contextPath.addSegment("scopedMembers"));
    }

    public ScopedRoleMembershipRequest scopedMembers(String id) {
        return new ScopedRoleMembershipRequest(contextPath.addSegment("scopedMembers").addKeys(new NameValue(id.toString())));
    }

}
