package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import odata.msgraph.client.beta.entity.Directory;
import odata.msgraph.client.beta.entity.collection.request.DirectoryObjectCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.FeatureRolloutPolicyCollectionRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

@JsonIgnoreType
public class DirectoryRequest extends EntityRequest<Directory> {

    public DirectoryRequest(ContextPath contextPath) {
        super(Directory.class, contextPath, SchemaInfo.INSTANCE);
    }

    public DirectoryObjectCollectionRequest deletedItems() {
        return new DirectoryObjectCollectionRequest(
                        contextPath.addSegment("deletedItems"));
    }

    public DirectoryObjectRequest deletedItems(String id) {
        return new DirectoryObjectRequest(contextPath.addSegment("deletedItems").addKeys(new NameValue(id.toString())));
    }

    public FeatureRolloutPolicyCollectionRequest featureRolloutPolicies() {
        return new FeatureRolloutPolicyCollectionRequest(
                        contextPath.addSegment("featureRolloutPolicies"));
    }

    public FeatureRolloutPolicyRequest featureRolloutPolicies(String id) {
        return new FeatureRolloutPolicyRequest(contextPath.addSegment("featureRolloutPolicies").addKeys(new NameValue(id.toString())));
    }

}
