package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.guavamini.Preconditions;
import com.github.davidmoten.odata.client.ActionRequestReturningNonCollectionUnwrapped;
import com.github.davidmoten.odata.client.CollectionPageNonEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.util.List;
import java.util.Map;

import odata.msgraph.client.beta.entity.DirectoryObject;
import odata.msgraph.client.beta.schema.SchemaInfo;

@JsonIgnoreType
public class DirectoryObjectRequest extends EntityRequest<DirectoryObject> {

    public DirectoryObjectRequest(ContextPath contextPath) {
        super(DirectoryObject.class, contextPath, SchemaInfo.INSTANCE);
    }

    @Action(name = "checkMemberGroups")
    @JsonIgnore
    public CollectionPageNonEntityRequest<String> checkMemberGroups(List<String> groupIds) {
        Preconditions.checkNotNull(groupIds, "groupIds cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("groupIds", "Collection(Edm.String)", Checks.checkIsAscii(groupIds))
            .build();
        return CollectionPageNonEntityRequest.forAction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.checkMemberGroups"), String.class, _parameters, com.github.davidmoten.odata.client.internal.EdmSchemaInfo.INSTANCE);
    }

    @Action(name = "checkMemberObjects")
    @JsonIgnore
    public CollectionPageNonEntityRequest<String> checkMemberObjects(List<String> ids) {
        Preconditions.checkNotNull(ids, "ids cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("ids", "Collection(Edm.String)", Checks.checkIsAscii(ids))
            .build();
        return CollectionPageNonEntityRequest.forAction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.checkMemberObjects"), String.class, _parameters, com.github.davidmoten.odata.client.internal.EdmSchemaInfo.INSTANCE);
    }

    @Action(name = "getMemberGroups")
    @JsonIgnore
    public CollectionPageNonEntityRequest<String> getMemberGroups(Boolean securityEnabledOnly) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("securityEnabledOnly", "Edm.Boolean", securityEnabledOnly)
            .build();
        return CollectionPageNonEntityRequest.forAction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getMemberGroups"), String.class, _parameters, com.github.davidmoten.odata.client.internal.EdmSchemaInfo.INSTANCE);
    }

    @Action(name = "getMemberObjects")
    @JsonIgnore
    public CollectionPageNonEntityRequest<String> getMemberObjects(Boolean securityEnabledOnly) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("securityEnabledOnly", "Edm.Boolean", securityEnabledOnly)
            .build();
        return CollectionPageNonEntityRequest.forAction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getMemberObjects"), String.class, _parameters, com.github.davidmoten.odata.client.internal.EdmSchemaInfo.INSTANCE);
    }

    @Action(name = "restore")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<DirectoryObject> restore() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestReturningNonCollectionUnwrapped<DirectoryObject>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.restore"), DirectoryObject.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

}
