package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import odata.msgraph.client.beta.entity.Dimension;
import odata.msgraph.client.beta.entity.collection.request.DimensionValueCollectionRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

@JsonIgnoreType
public class DimensionRequest extends EntityRequest<Dimension> {

    public DimensionRequest(ContextPath contextPath) {
        super(Dimension.class, contextPath, SchemaInfo.INSTANCE);
    }

    public DimensionValueCollectionRequest dimensionValues() {
        return new DimensionValueCollectionRequest(
                        contextPath.addSegment("dimensionValues"));
    }

    public DimensionValueRequest dimensionValues(String id) {
        return new DimensionValueRequest(contextPath.addSegment("dimensionValues").addKeys(new NameValue(id.toString())));
    }

}
