package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ActionRequestNoReturn;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.util.List;
import java.util.Map;

import odata.msgraph.client.beta.entity.DeviceManagementScriptAssignment;
import odata.msgraph.client.beta.entity.DeviceManagementScriptGroupAssignment;
import odata.msgraph.client.beta.entity.DeviceShellScript;
import odata.msgraph.client.beta.entity.collection.request.DeviceManagementScriptAssignmentCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.DeviceManagementScriptDeviceStateCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.DeviceManagementScriptGroupAssignmentCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.DeviceManagementScriptUserStateCollectionRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

@JsonIgnoreType
public class DeviceShellScriptRequest extends EntityRequest<DeviceShellScript> {

    public DeviceShellScriptRequest(ContextPath contextPath) {
        super(DeviceShellScript.class, contextPath, SchemaInfo.INSTANCE);
    }

    public DeviceManagementScriptGroupAssignmentCollectionRequest groupAssignments() {
        return new DeviceManagementScriptGroupAssignmentCollectionRequest(
                        contextPath.addSegment("groupAssignments"));
    }

    public DeviceManagementScriptGroupAssignmentRequest groupAssignments(String id) {
        return new DeviceManagementScriptGroupAssignmentRequest(contextPath.addSegment("groupAssignments").addKeys(new NameValue(id.toString())));
    }

    public DeviceManagementScriptAssignmentCollectionRequest assignments() {
        return new DeviceManagementScriptAssignmentCollectionRequest(
                        contextPath.addSegment("assignments"));
    }

    public DeviceManagementScriptAssignmentRequest assignments(String id) {
        return new DeviceManagementScriptAssignmentRequest(contextPath.addSegment("assignments").addKeys(new NameValue(id.toString())));
    }

    public DeviceManagementScriptRunSummaryRequest runSummary() {
        return new DeviceManagementScriptRunSummaryRequest(contextPath.addSegment("runSummary"));
    }

    public DeviceManagementScriptDeviceStateCollectionRequest deviceRunStates() {
        return new DeviceManagementScriptDeviceStateCollectionRequest(
                        contextPath.addSegment("deviceRunStates"));
    }

    public DeviceManagementScriptDeviceStateRequest deviceRunStates(String id) {
        return new DeviceManagementScriptDeviceStateRequest(contextPath.addSegment("deviceRunStates").addKeys(new NameValue(id.toString())));
    }

    public DeviceManagementScriptUserStateCollectionRequest userRunStates() {
        return new DeviceManagementScriptUserStateCollectionRequest(
                        contextPath.addSegment("userRunStates"));
    }

    public DeviceManagementScriptUserStateRequest userRunStates(String id) {
        return new DeviceManagementScriptUserStateRequest(contextPath.addSegment("userRunStates").addKeys(new NameValue(id.toString())));
    }

    @Action(name = "assign")
    @JsonIgnore
    public ActionRequestNoReturn assign(List<DeviceManagementScriptGroupAssignment> deviceManagementScriptGroupAssignments, List<DeviceManagementScriptAssignment> deviceManagementScriptAssignments) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("deviceManagementScriptGroupAssignments", "Collection(microsoft.graph.deviceManagementScriptGroupAssignment)", deviceManagementScriptGroupAssignments)
            .put("deviceManagementScriptAssignments", "Collection(microsoft.graph.deviceManagementScriptAssignment)", deviceManagementScriptAssignments)
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.assign"), _parameters);
    }

}
