package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import odata.msgraph.client.beta.entity.DeviceManagementTemplateSettingCategory;
import odata.msgraph.client.beta.entity.collection.request.DeviceManagementSettingInstanceCollectionRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

@JsonIgnoreType
public class DeviceManagementTemplateSettingCategoryRequest extends EntityRequest<DeviceManagementTemplateSettingCategory> {

    public DeviceManagementTemplateSettingCategoryRequest(ContextPath contextPath) {
        super(DeviceManagementTemplateSettingCategory.class, contextPath, SchemaInfo.INSTANCE);
    }

    public DeviceManagementSettingInstanceCollectionRequest recommendedSettings() {
        return new DeviceManagementSettingInstanceCollectionRequest(
                        contextPath.addSegment("recommendedSettings"));
    }

    public DeviceManagementSettingInstanceRequest recommendedSettings(String id) {
        return new DeviceManagementSettingInstanceRequest(contextPath.addSegment("recommendedSettings").addKeys(new NameValue(id.toString())));
    }

}
