package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import odata.msgraph.client.beta.entity.DeviceManagementSettingCategory;
import odata.msgraph.client.beta.entity.collection.request.DeviceManagementSettingDefinitionCollectionRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

@JsonIgnoreType
public class DeviceManagementSettingCategoryRequest extends EntityRequest<DeviceManagementSettingCategory> {

    public DeviceManagementSettingCategoryRequest(ContextPath contextPath) {
        super(DeviceManagementSettingCategory.class, contextPath, SchemaInfo.INSTANCE);
    }

    public DeviceManagementSettingDefinitionCollectionRequest settingDefinitions() {
        return new DeviceManagementSettingDefinitionCollectionRequest(
                        contextPath.addSegment("settingDefinitions"));
    }

    public DeviceManagementSettingDefinitionRequest settingDefinitions(String id) {
        return new DeviceManagementSettingDefinitionRequest(contextPath.addSegment("settingDefinitions").addKeys(new NameValue(id.toString())));
    }

}
