package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import odata.msgraph.client.beta.entity.DeviceManagementScriptUserState;
import odata.msgraph.client.beta.entity.collection.request.DeviceManagementScriptDeviceStateCollectionRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

@JsonIgnoreType
public class DeviceManagementScriptUserStateRequest extends EntityRequest<DeviceManagementScriptUserState> {

    public DeviceManagementScriptUserStateRequest(ContextPath contextPath) {
        super(DeviceManagementScriptUserState.class, contextPath, SchemaInfo.INSTANCE);
    }

    public DeviceManagementScriptDeviceStateCollectionRequest deviceRunStates() {
        return new DeviceManagementScriptDeviceStateCollectionRequest(
                        contextPath.addSegment("deviceRunStates"));
    }

    public DeviceManagementScriptDeviceStateRequest deviceRunStates(String id) {
        return new DeviceManagementScriptDeviceStateRequest(contextPath.addSegment("deviceRunStates").addKeys(new NameValue(id.toString())));
    }

}
