package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.guavamini.Preconditions;
import com.github.davidmoten.odata.client.ActionRequestNoReturn;
import com.github.davidmoten.odata.client.CollectionPageNonEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.FunctionRequestReturningNonCollection;
import com.github.davidmoten.odata.client.FunctionRequestReturningNonCollectionUnwrapped;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.annotation.Function;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.util.List;
import java.util.Map;

import odata.msgraph.client.beta.complex.ComanagedDevicesSummary;
import odata.msgraph.client.beta.complex.ComanagementEligibleDevicesSummary;
import odata.msgraph.client.beta.complex.DeviceAndAppManagementAssignedRoleDetails;
import odata.msgraph.client.beta.complex.RolePermission;
import odata.msgraph.client.beta.entity.DeviceManagement;
import odata.msgraph.client.beta.entity.RoleScopeTag;
import odata.msgraph.client.beta.entity.collection.request.AndroidDeviceOwnerEnrollmentProfileCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.AndroidForWorkAppConfigurationSchemaCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.AndroidForWorkEnrollmentProfileCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.AndroidManagedStoreAppConfigurationSchemaCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.AppleUserInitiatedEnrollmentProfileCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.AuditEventCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.CartToClassAssociationCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.ComanagementEligibleDeviceCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.ComplianceManagementPartnerCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.DataSharingConsentCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.DepOnboardingSettingCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.DetectedAppCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.DeviceAndAppManagementAssignmentFilterCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.DeviceAndAppManagementRoleAssignmentCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.DeviceCategoryCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.DeviceCompliancePolicyCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.DeviceCompliancePolicySettingStateSummaryCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.DeviceComplianceScriptCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.DeviceConfigurationCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.DeviceConfigurationConflictSummaryCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.DeviceEnrollmentConfigurationCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.DeviceHealthScriptCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.DeviceManagementAutopilotEventCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.DeviceManagementDerivedCredentialSettingsCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.DeviceManagementDomainJoinConnectorCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.DeviceManagementExchangeConnectorCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.DeviceManagementExchangeOnPremisesPolicyCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.DeviceManagementIntentCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.DeviceManagementPartnerCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.DeviceManagementScriptCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.DeviceManagementSettingCategoryCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.DeviceManagementSettingDefinitionCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.DeviceManagementTemplateCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.DeviceManagementTroubleshootingEventCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.DeviceShellScriptCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.EmbeddedSIMActivationCodePoolCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.GroupPolicyCategoryCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.GroupPolicyConfigurationCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.GroupPolicyDefinitionCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.GroupPolicyDefinitionFileCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.GroupPolicyMigrationReportCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.GroupPolicyObjectFileCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.GroupPolicyUploadedDefinitionFileCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.ImportedDeviceIdentityCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.ImportedWindowsAutopilotDeviceIdentityCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.IntuneBrandingProfileCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.IosUpdateDeviceStatusCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.ManagedAllDeviceCertificateStateCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.ManagedDeviceCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.ManagedDeviceEncryptionStateCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.ManagementConditionCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.ManagementConditionStatementCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.MobileAppTroubleshootingEventCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.MobileThreatDefenseConnectorCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.NdesConnectorCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.NotificationMessageTemplateCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.RemoteActionAuditCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.RemoteAssistancePartnerCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.ResourceOperationCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.RestrictedAppsViolationCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.RoleDefinitionCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.RoleScopeTagCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.TelecomExpenseManagementPartnerCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.TermsAndConditionsCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.UserExperienceAnalyticsBaselineCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.UserExperienceAnalyticsCategoryCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.UserExperienceAnalyticsDevicePerformanceCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.UserExperienceAnalyticsDeviceStartupHistoryCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.UserExperienceAnalyticsDeviceStartupProcessCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.UserExperienceAnalyticsDeviceStartupProcessPerformanceCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.UserExperienceAnalyticsScoreHistoryCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.UserPFXCertificateCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.WindowsAutopilotDeploymentProfileCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.WindowsAutopilotDeviceIdentityCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.WindowsFeatureUpdateProfileCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.WindowsInformationProtectionAppLearningSummaryCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.WindowsInformationProtectionNetworkLearningSummaryCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.WindowsMalwareInformationCollectionRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

@JsonIgnoreType
public class DeviceManagementRequest extends EntityRequest<DeviceManagement> {

    public DeviceManagementRequest(ContextPath contextPath) {
        super(DeviceManagement.class, contextPath, SchemaInfo.INSTANCE);
    }

    public AuditEventCollectionRequest auditEvents() {
        return new AuditEventCollectionRequest(
                        contextPath.addSegment("auditEvents"));
    }

    public AuditEventRequest auditEvents(String id) {
        return new AuditEventRequest(contextPath.addSegment("auditEvents").addKeys(new NameValue(id.toString())));
    }

    public AndroidForWorkSettingsRequest androidForWorkSettings() {
        return new AndroidForWorkSettingsRequest(contextPath.addSegment("androidForWorkSettings"));
    }

    public AndroidForWorkAppConfigurationSchemaCollectionRequest androidForWorkAppConfigurationSchemas() {
        return new AndroidForWorkAppConfigurationSchemaCollectionRequest(
                        contextPath.addSegment("androidForWorkAppConfigurationSchemas"));
    }

    public AndroidForWorkAppConfigurationSchemaRequest androidForWorkAppConfigurationSchemas(String id) {
        return new AndroidForWorkAppConfigurationSchemaRequest(contextPath.addSegment("androidForWorkAppConfigurationSchemas").addKeys(new NameValue(id.toString())));
    }

    public AndroidForWorkEnrollmentProfileCollectionRequest androidForWorkEnrollmentProfiles() {
        return new AndroidForWorkEnrollmentProfileCollectionRequest(
                        contextPath.addSegment("androidForWorkEnrollmentProfiles"));
    }

    public AndroidForWorkEnrollmentProfileRequest androidForWorkEnrollmentProfiles(String id) {
        return new AndroidForWorkEnrollmentProfileRequest(contextPath.addSegment("androidForWorkEnrollmentProfiles").addKeys(new NameValue(id.toString())));
    }

    public AndroidManagedStoreAccountEnterpriseSettingsRequest androidManagedStoreAccountEnterpriseSettings() {
        return new AndroidManagedStoreAccountEnterpriseSettingsRequest(contextPath.addSegment("androidManagedStoreAccountEnterpriseSettings"));
    }

    public AndroidManagedStoreAppConfigurationSchemaCollectionRequest androidManagedStoreAppConfigurationSchemas() {
        return new AndroidManagedStoreAppConfigurationSchemaCollectionRequest(
                        contextPath.addSegment("androidManagedStoreAppConfigurationSchemas"));
    }

    public AndroidManagedStoreAppConfigurationSchemaRequest androidManagedStoreAppConfigurationSchemas(String id) {
        return new AndroidManagedStoreAppConfigurationSchemaRequest(contextPath.addSegment("androidManagedStoreAppConfigurationSchemas").addKeys(new NameValue(id.toString())));
    }

    public AndroidDeviceOwnerEnrollmentProfileCollectionRequest androidDeviceOwnerEnrollmentProfiles() {
        return new AndroidDeviceOwnerEnrollmentProfileCollectionRequest(
                        contextPath.addSegment("androidDeviceOwnerEnrollmentProfiles"));
    }

    public AndroidDeviceOwnerEnrollmentProfileRequest androidDeviceOwnerEnrollmentProfiles(String id) {
        return new AndroidDeviceOwnerEnrollmentProfileRequest(contextPath.addSegment("androidDeviceOwnerEnrollmentProfiles").addKeys(new NameValue(id.toString())));
    }

    public DeviceAndAppManagementAssignmentFilterCollectionRequest assignmentFilters() {
        return new DeviceAndAppManagementAssignmentFilterCollectionRequest(
                        contextPath.addSegment("assignmentFilters"));
    }

    public DeviceAndAppManagementAssignmentFilterRequest assignmentFilters(String id) {
        return new DeviceAndAppManagementAssignmentFilterRequest(contextPath.addSegment("assignmentFilters").addKeys(new NameValue(id.toString())));
    }

    public TermsAndConditionsCollectionRequest termsAndConditions() {
        return new TermsAndConditionsCollectionRequest(
                        contextPath.addSegment("termsAndConditions"));
    }

    public TermsAndConditionsRequest termsAndConditions(String id) {
        return new TermsAndConditionsRequest(contextPath.addSegment("termsAndConditions").addKeys(new NameValue(id.toString())));
    }

    public DeviceConfigurationCollectionRequest deviceConfigurations() {
        return new DeviceConfigurationCollectionRequest(
                        contextPath.addSegment("deviceConfigurations"));
    }

    public DeviceConfigurationRequest deviceConfigurations(String id) {
        return new DeviceConfigurationRequest(contextPath.addSegment("deviceConfigurations").addKeys(new NameValue(id.toString())));
    }

    public DeviceCompliancePolicyCollectionRequest deviceCompliancePolicies() {
        return new DeviceCompliancePolicyCollectionRequest(
                        contextPath.addSegment("deviceCompliancePolicies"));
    }

    public DeviceCompliancePolicyRequest deviceCompliancePolicies(String id) {
        return new DeviceCompliancePolicyRequest(contextPath.addSegment("deviceCompliancePolicies").addKeys(new NameValue(id.toString())));
    }

    public SoftwareUpdateStatusSummaryRequest softwareUpdateStatusSummary() {
        return new SoftwareUpdateStatusSummaryRequest(contextPath.addSegment("softwareUpdateStatusSummary"));
    }

    public DeviceCompliancePolicyDeviceStateSummaryRequest deviceCompliancePolicyDeviceStateSummary() {
        return new DeviceCompliancePolicyDeviceStateSummaryRequest(contextPath.addSegment("deviceCompliancePolicyDeviceStateSummary"));
    }

    public DeviceCompliancePolicySettingStateSummaryCollectionRequest deviceCompliancePolicySettingStateSummaries() {
        return new DeviceCompliancePolicySettingStateSummaryCollectionRequest(
                        contextPath.addSegment("deviceCompliancePolicySettingStateSummaries"));
    }

    public DeviceCompliancePolicySettingStateSummaryRequest deviceCompliancePolicySettingStateSummaries(String id) {
        return new DeviceCompliancePolicySettingStateSummaryRequest(contextPath.addSegment("deviceCompliancePolicySettingStateSummaries").addKeys(new NameValue(id.toString())));
    }

    public AdvancedThreatProtectionOnboardingStateSummaryRequest advancedThreatProtectionOnboardingStateSummary() {
        return new AdvancedThreatProtectionOnboardingStateSummaryRequest(contextPath.addSegment("advancedThreatProtectionOnboardingStateSummary"));
    }

    public DeviceConfigurationDeviceStateSummaryRequest deviceConfigurationDeviceStateSummaries() {
        return new DeviceConfigurationDeviceStateSummaryRequest(contextPath.addSegment("deviceConfigurationDeviceStateSummaries"));
    }

    public DeviceConfigurationUserStateSummaryRequest deviceConfigurationUserStateSummaries() {
        return new DeviceConfigurationUserStateSummaryRequest(contextPath.addSegment("deviceConfigurationUserStateSummaries"));
    }

    public CartToClassAssociationCollectionRequest cartToClassAssociations() {
        return new CartToClassAssociationCollectionRequest(
                        contextPath.addSegment("cartToClassAssociations"));
    }

    public CartToClassAssociationRequest cartToClassAssociations(String id) {
        return new CartToClassAssociationRequest(contextPath.addSegment("cartToClassAssociations").addKeys(new NameValue(id.toString())));
    }

    public IosUpdateDeviceStatusCollectionRequest iosUpdateStatuses() {
        return new IosUpdateDeviceStatusCollectionRequest(
                        contextPath.addSegment("iosUpdateStatuses"));
    }

    public IosUpdateDeviceStatusRequest iosUpdateStatuses(String id) {
        return new IosUpdateDeviceStatusRequest(contextPath.addSegment("iosUpdateStatuses").addKeys(new NameValue(id.toString())));
    }

    public NdesConnectorCollectionRequest ndesConnectors() {
        return new NdesConnectorCollectionRequest(
                        contextPath.addSegment("ndesConnectors"));
    }

    public NdesConnectorRequest ndesConnectors(String id) {
        return new NdesConnectorRequest(contextPath.addSegment("ndesConnectors").addKeys(new NameValue(id.toString())));
    }

    public RestrictedAppsViolationCollectionRequest deviceConfigurationRestrictedAppsViolations() {
        return new RestrictedAppsViolationCollectionRequest(
                        contextPath.addSegment("deviceConfigurationRestrictedAppsViolations"));
    }

    public RestrictedAppsViolationRequest deviceConfigurationRestrictedAppsViolations(String id) {
        return new RestrictedAppsViolationRequest(contextPath.addSegment("deviceConfigurationRestrictedAppsViolations").addKeys(new NameValue(id.toString())));
    }

    public ManagedDeviceEncryptionStateCollectionRequest managedDeviceEncryptionStates() {
        return new ManagedDeviceEncryptionStateCollectionRequest(
                        contextPath.addSegment("managedDeviceEncryptionStates"));
    }

    public ManagedDeviceEncryptionStateRequest managedDeviceEncryptionStates(String id) {
        return new ManagedDeviceEncryptionStateRequest(contextPath.addSegment("managedDeviceEncryptionStates").addKeys(new NameValue(id.toString())));
    }

    public DeviceConfigurationConflictSummaryCollectionRequest deviceConfigurationConflictSummary() {
        return new DeviceConfigurationConflictSummaryCollectionRequest(
                        contextPath.addSegment("deviceConfigurationConflictSummary"));
    }

    public DeviceConfigurationConflictSummaryRequest deviceConfigurationConflictSummary(String id) {
        return new DeviceConfigurationConflictSummaryRequest(contextPath.addSegment("deviceConfigurationConflictSummary").addKeys(new NameValue(id.toString())));
    }

    public ManagedAllDeviceCertificateStateCollectionRequest deviceConfigurationsAllManagedDeviceCertificateStates() {
        return new ManagedAllDeviceCertificateStateCollectionRequest(
                        contextPath.addSegment("deviceConfigurationsAllManagedDeviceCertificateStates"));
    }

    public ManagedAllDeviceCertificateStateRequest deviceConfigurationsAllManagedDeviceCertificateStates(String id) {
        return new ManagedAllDeviceCertificateStateRequest(contextPath.addSegment("deviceConfigurationsAllManagedDeviceCertificateStates").addKeys(new NameValue(id.toString())));
    }

    public DeviceCategoryCollectionRequest deviceCategories() {
        return new DeviceCategoryCollectionRequest(
                        contextPath.addSegment("deviceCategories"));
    }

    public DeviceCategoryRequest deviceCategories(String id) {
        return new DeviceCategoryRequest(contextPath.addSegment("deviceCategories").addKeys(new NameValue(id.toString())));
    }

    public DeviceManagementExchangeConnectorCollectionRequest exchangeConnectors() {
        return new DeviceManagementExchangeConnectorCollectionRequest(
                        contextPath.addSegment("exchangeConnectors"));
    }

    public DeviceManagementExchangeConnectorRequest exchangeConnectors(String id) {
        return new DeviceManagementExchangeConnectorRequest(contextPath.addSegment("exchangeConnectors").addKeys(new NameValue(id.toString())));
    }

    public DeviceEnrollmentConfigurationCollectionRequest deviceEnrollmentConfigurations() {
        return new DeviceEnrollmentConfigurationCollectionRequest(
                        contextPath.addSegment("deviceEnrollmentConfigurations"));
    }

    public DeviceEnrollmentConfigurationRequest deviceEnrollmentConfigurations(String id) {
        return new DeviceEnrollmentConfigurationRequest(contextPath.addSegment("deviceEnrollmentConfigurations").addKeys(new NameValue(id.toString())));
    }

    public DeviceManagementExchangeOnPremisesPolicyRequest exchangeOnPremisesPolicy() {
        return new DeviceManagementExchangeOnPremisesPolicyRequest(contextPath.addSegment("exchangeOnPremisesPolicy"));
    }

    public DeviceManagementExchangeOnPremisesPolicyCollectionRequest exchangeOnPremisesPolicies() {
        return new DeviceManagementExchangeOnPremisesPolicyCollectionRequest(
                        contextPath.addSegment("exchangeOnPremisesPolicies"));
    }

    public DeviceManagementExchangeOnPremisesPolicyRequest exchangeOnPremisesPolicies(String id) {
        return new DeviceManagementExchangeOnPremisesPolicyRequest(contextPath.addSegment("exchangeOnPremisesPolicies").addKeys(new NameValue(id.toString())));
    }

    public OnPremisesConditionalAccessSettingsRequest conditionalAccessSettings() {
        return new OnPremisesConditionalAccessSettingsRequest(contextPath.addSegment("conditionalAccessSettings"));
    }

    public MobileThreatDefenseConnectorCollectionRequest mobileThreatDefenseConnectors() {
        return new MobileThreatDefenseConnectorCollectionRequest(
                        contextPath.addSegment("mobileThreatDefenseConnectors"));
    }

    public MobileThreatDefenseConnectorRequest mobileThreatDefenseConnectors(String id) {
        return new MobileThreatDefenseConnectorRequest(contextPath.addSegment("mobileThreatDefenseConnectors").addKeys(new NameValue(id.toString())));
    }

    public DeviceManagementPartnerCollectionRequest deviceManagementPartners() {
        return new DeviceManagementPartnerCollectionRequest(
                        contextPath.addSegment("deviceManagementPartners"));
    }

    public DeviceManagementPartnerRequest deviceManagementPartners(String id) {
        return new DeviceManagementPartnerRequest(contextPath.addSegment("deviceManagementPartners").addKeys(new NameValue(id.toString())));
    }

    public ComplianceManagementPartnerCollectionRequest complianceManagementPartners() {
        return new ComplianceManagementPartnerCollectionRequest(
                        contextPath.addSegment("complianceManagementPartners"));
    }

    public ComplianceManagementPartnerRequest complianceManagementPartners(String id) {
        return new ComplianceManagementPartnerRequest(contextPath.addSegment("complianceManagementPartners").addKeys(new NameValue(id.toString())));
    }

    public DeviceManagementIntentCollectionRequest intents() {
        return new DeviceManagementIntentCollectionRequest(
                        contextPath.addSegment("intents"));
    }

    public DeviceManagementIntentRequest intents(String id) {
        return new DeviceManagementIntentRequest(contextPath.addSegment("intents").addKeys(new NameValue(id.toString())));
    }

    public DeviceManagementSettingDefinitionCollectionRequest settingDefinitions() {
        return new DeviceManagementSettingDefinitionCollectionRequest(
                        contextPath.addSegment("settingDefinitions"));
    }

    public DeviceManagementSettingDefinitionRequest settingDefinitions(String id) {
        return new DeviceManagementSettingDefinitionRequest(contextPath.addSegment("settingDefinitions").addKeys(new NameValue(id.toString())));
    }

    public DeviceManagementTemplateCollectionRequest templates() {
        return new DeviceManagementTemplateCollectionRequest(
                        contextPath.addSegment("templates"));
    }

    public DeviceManagementTemplateRequest templates(String id) {
        return new DeviceManagementTemplateRequest(contextPath.addSegment("templates").addKeys(new NameValue(id.toString())));
    }

    public DeviceManagementSettingCategoryCollectionRequest categories() {
        return new DeviceManagementSettingCategoryCollectionRequest(
                        contextPath.addSegment("categories"));
    }

    public DeviceManagementSettingCategoryRequest categories(String id) {
        return new DeviceManagementSettingCategoryRequest(contextPath.addSegment("categories").addKeys(new NameValue(id.toString())));
    }

    public RemoteActionAuditCollectionRequest remoteActionAudits() {
        return new RemoteActionAuditCollectionRequest(
                        contextPath.addSegment("remoteActionAudits"));
    }

    public RemoteActionAuditRequest remoteActionAudits(String id) {
        return new RemoteActionAuditRequest(contextPath.addSegment("remoteActionAudits").addKeys(new NameValue(id.toString())));
    }

    public ApplePushNotificationCertificateRequest applePushNotificationCertificate() {
        return new ApplePushNotificationCertificateRequest(contextPath.addSegment("applePushNotificationCertificate"));
    }

    public DeviceManagementScriptCollectionRequest deviceManagementScripts() {
        return new DeviceManagementScriptCollectionRequest(
                        contextPath.addSegment("deviceManagementScripts"));
    }

    public DeviceManagementScriptRequest deviceManagementScripts(String id) {
        return new DeviceManagementScriptRequest(contextPath.addSegment("deviceManagementScripts").addKeys(new NameValue(id.toString())));
    }

    public DeviceShellScriptCollectionRequest deviceShellScripts() {
        return new DeviceShellScriptCollectionRequest(
                        contextPath.addSegment("deviceShellScripts"));
    }

    public DeviceShellScriptRequest deviceShellScripts(String id) {
        return new DeviceShellScriptRequest(contextPath.addSegment("deviceShellScripts").addKeys(new NameValue(id.toString())));
    }

    public DeviceHealthScriptCollectionRequest deviceHealthScripts() {
        return new DeviceHealthScriptCollectionRequest(
                        contextPath.addSegment("deviceHealthScripts"));
    }

    public DeviceHealthScriptRequest deviceHealthScripts(String id) {
        return new DeviceHealthScriptRequest(contextPath.addSegment("deviceHealthScripts").addKeys(new NameValue(id.toString())));
    }

    public DeviceComplianceScriptCollectionRequest deviceComplianceScripts() {
        return new DeviceComplianceScriptCollectionRequest(
                        contextPath.addSegment("deviceComplianceScripts"));
    }

    public DeviceComplianceScriptRequest deviceComplianceScripts(String id) {
        return new DeviceComplianceScriptRequest(contextPath.addSegment("deviceComplianceScripts").addKeys(new NameValue(id.toString())));
    }

    public ManagedDeviceOverviewRequest managedDeviceOverview() {
        return new ManagedDeviceOverviewRequest(contextPath.addSegment("managedDeviceOverview"));
    }

    public DetectedAppCollectionRequest detectedApps() {
        return new DetectedAppCollectionRequest(
                        contextPath.addSegment("detectedApps"));
    }

    public DetectedAppRequest detectedApps(String id) {
        return new DetectedAppRequest(contextPath.addSegment("detectedApps").addKeys(new NameValue(id.toString())));
    }

    public ManagedDeviceCollectionRequest managedDevices() {
        return new ManagedDeviceCollectionRequest(
                        contextPath.addSegment("managedDevices"));
    }

    public ManagedDeviceRequest managedDevices(String id) {
        return new ManagedDeviceRequest(contextPath.addSegment("managedDevices").addKeys(new NameValue(id.toString())));
    }

    public WindowsMalwareInformationCollectionRequest windowsMalwareInformation() {
        return new WindowsMalwareInformationCollectionRequest(
                        contextPath.addSegment("windowsMalwareInformation"));
    }

    public WindowsMalwareInformationRequest windowsMalwareInformation(String id) {
        return new WindowsMalwareInformationRequest(contextPath.addSegment("windowsMalwareInformation").addKeys(new NameValue(id.toString())));
    }

    public DataSharingConsentCollectionRequest dataSharingConsents() {
        return new DataSharingConsentCollectionRequest(
                        contextPath.addSegment("dataSharingConsents"));
    }

    public DataSharingConsentRequest dataSharingConsents(String id) {
        return new DataSharingConsentRequest(contextPath.addSegment("dataSharingConsents").addKeys(new NameValue(id.toString())));
    }

    public MobileAppTroubleshootingEventCollectionRequest mobileAppTroubleshootingEvents() {
        return new MobileAppTroubleshootingEventCollectionRequest(
                        contextPath.addSegment("mobileAppTroubleshootingEvents"));
    }

    public MobileAppTroubleshootingEventRequest mobileAppTroubleshootingEvents(String id) {
        return new MobileAppTroubleshootingEventRequest(contextPath.addSegment("mobileAppTroubleshootingEvents").addKeys(new NameValue(id.toString())));
    }

    public UserExperienceAnalyticsOverviewRequest userExperienceAnalyticsOverview() {
        return new UserExperienceAnalyticsOverviewRequest(contextPath.addSegment("userExperienceAnalyticsOverview"));
    }

    public UserExperienceAnalyticsBaselineCollectionRequest userExperienceAnalyticsBaselines() {
        return new UserExperienceAnalyticsBaselineCollectionRequest(
                        contextPath.addSegment("userExperienceAnalyticsBaselines"));
    }

    public UserExperienceAnalyticsBaselineRequest userExperienceAnalyticsBaselines(String id) {
        return new UserExperienceAnalyticsBaselineRequest(contextPath.addSegment("userExperienceAnalyticsBaselines").addKeys(new NameValue(id.toString())));
    }

    public UserExperienceAnalyticsCategoryCollectionRequest userExperienceAnalyticsCategories() {
        return new UserExperienceAnalyticsCategoryCollectionRequest(
                        contextPath.addSegment("userExperienceAnalyticsCategories"));
    }

    public UserExperienceAnalyticsCategoryRequest userExperienceAnalyticsCategories(String id) {
        return new UserExperienceAnalyticsCategoryRequest(contextPath.addSegment("userExperienceAnalyticsCategories").addKeys(new NameValue(id.toString())));
    }

    public UserExperienceAnalyticsDevicePerformanceCollectionRequest userExperienceAnalyticsDevicePerformance() {
        return new UserExperienceAnalyticsDevicePerformanceCollectionRequest(
                        contextPath.addSegment("userExperienceAnalyticsDevicePerformance"));
    }

    public UserExperienceAnalyticsDevicePerformanceRequest userExperienceAnalyticsDevicePerformance(String id) {
        return new UserExperienceAnalyticsDevicePerformanceRequest(contextPath.addSegment("userExperienceAnalyticsDevicePerformance").addKeys(new NameValue(id.toString())));
    }

    public UserExperienceAnalyticsRegressionSummaryRequest userExperienceAnalyticsRegressionSummary() {
        return new UserExperienceAnalyticsRegressionSummaryRequest(contextPath.addSegment("userExperienceAnalyticsRegressionSummary"));
    }

    public UserExperienceAnalyticsDeviceStartupHistoryCollectionRequest userExperienceAnalyticsDeviceStartupHistory() {
        return new UserExperienceAnalyticsDeviceStartupHistoryCollectionRequest(
                        contextPath.addSegment("userExperienceAnalyticsDeviceStartupHistory"));
    }

    public UserExperienceAnalyticsDeviceStartupHistoryRequest userExperienceAnalyticsDeviceStartupHistory(String id) {
        return new UserExperienceAnalyticsDeviceStartupHistoryRequest(contextPath.addSegment("userExperienceAnalyticsDeviceStartupHistory").addKeys(new NameValue(id.toString())));
    }

    public UserExperienceAnalyticsDeviceStartupProcessCollectionRequest userExperienceAnalyticsDeviceStartupProcesses() {
        return new UserExperienceAnalyticsDeviceStartupProcessCollectionRequest(
                        contextPath.addSegment("userExperienceAnalyticsDeviceStartupProcesses"));
    }

    public UserExperienceAnalyticsDeviceStartupProcessRequest userExperienceAnalyticsDeviceStartupProcesses(String id) {
        return new UserExperienceAnalyticsDeviceStartupProcessRequest(contextPath.addSegment("userExperienceAnalyticsDeviceStartupProcesses").addKeys(new NameValue(id.toString())));
    }

    public UserExperienceAnalyticsDeviceStartupProcessPerformanceCollectionRequest userExperienceAnalyticsDeviceStartupProcessPerformance() {
        return new UserExperienceAnalyticsDeviceStartupProcessPerformanceCollectionRequest(
                        contextPath.addSegment("userExperienceAnalyticsDeviceStartupProcessPerformance"));
    }

    public UserExperienceAnalyticsDeviceStartupProcessPerformanceRequest userExperienceAnalyticsDeviceStartupProcessPerformance(String id) {
        return new UserExperienceAnalyticsDeviceStartupProcessPerformanceRequest(contextPath.addSegment("userExperienceAnalyticsDeviceStartupProcessPerformance").addKeys(new NameValue(id.toString())));
    }

    public UserExperienceAnalyticsScoreHistoryCollectionRequest userExperienceAnalyticsScoreHistory() {
        return new UserExperienceAnalyticsScoreHistoryCollectionRequest(
                        contextPath.addSegment("userExperienceAnalyticsScoreHistory"));
    }

    public UserExperienceAnalyticsScoreHistoryRequest userExperienceAnalyticsScoreHistory(String id) {
        return new UserExperienceAnalyticsScoreHistoryRequest(contextPath.addSegment("userExperienceAnalyticsScoreHistory").addKeys(new NameValue(id.toString())));
    }

    public ManagedDeviceCollectionRequest comanagedDevices() {
        return new ManagedDeviceCollectionRequest(
                        contextPath.addSegment("comanagedDevices"));
    }

    public ManagedDeviceRequest comanagedDevices(String id) {
        return new ManagedDeviceRequest(contextPath.addSegment("comanagedDevices").addKeys(new NameValue(id.toString())));
    }

    public ComanagementEligibleDeviceCollectionRequest comanagementEligibleDevices() {
        return new ComanagementEligibleDeviceCollectionRequest(
                        contextPath.addSegment("comanagementEligibleDevices"));
    }

    public ComanagementEligibleDeviceRequest comanagementEligibleDevices(String id) {
        return new ComanagementEligibleDeviceRequest(contextPath.addSegment("comanagementEligibleDevices").addKeys(new NameValue(id.toString())));
    }

    public DeviceManagementDerivedCredentialSettingsCollectionRequest derivedCredentials() {
        return new DeviceManagementDerivedCredentialSettingsCollectionRequest(
                        contextPath.addSegment("derivedCredentials"));
    }

    public DeviceManagementDerivedCredentialSettingsRequest derivedCredentials(String id) {
        return new DeviceManagementDerivedCredentialSettingsRequest(contextPath.addSegment("derivedCredentials").addKeys(new NameValue(id.toString())));
    }

    public WindowsAutopilotSettingsRequest windowsAutopilotSettings() {
        return new WindowsAutopilotSettingsRequest(contextPath.addSegment("windowsAutopilotSettings"));
    }

    public WindowsAutopilotDeviceIdentityCollectionRequest windowsAutopilotDeviceIdentities() {
        return new WindowsAutopilotDeviceIdentityCollectionRequest(
                        contextPath.addSegment("windowsAutopilotDeviceIdentities"));
    }

    public WindowsAutopilotDeviceIdentityRequest windowsAutopilotDeviceIdentities(String id) {
        return new WindowsAutopilotDeviceIdentityRequest(contextPath.addSegment("windowsAutopilotDeviceIdentities").addKeys(new NameValue(id.toString())));
    }

    public WindowsAutopilotDeploymentProfileCollectionRequest windowsAutopilotDeploymentProfiles() {
        return new WindowsAutopilotDeploymentProfileCollectionRequest(
                        contextPath.addSegment("windowsAutopilotDeploymentProfiles"));
    }

    public WindowsAutopilotDeploymentProfileRequest windowsAutopilotDeploymentProfiles(String id) {
        return new WindowsAutopilotDeploymentProfileRequest(contextPath.addSegment("windowsAutopilotDeploymentProfiles").addKeys(new NameValue(id.toString())));
    }

    public ImportedDeviceIdentityCollectionRequest importedDeviceIdentities() {
        return new ImportedDeviceIdentityCollectionRequest(
                        contextPath.addSegment("importedDeviceIdentities"));
    }

    public ImportedDeviceIdentityRequest importedDeviceIdentities(String id) {
        return new ImportedDeviceIdentityRequest(contextPath.addSegment("importedDeviceIdentities").addKeys(new NameValue(id.toString())));
    }

    public DepOnboardingSettingCollectionRequest depOnboardingSettings() {
        return new DepOnboardingSettingCollectionRequest(
                        contextPath.addSegment("depOnboardingSettings"));
    }

    public DepOnboardingSettingRequest depOnboardingSettings(String id) {
        return new DepOnboardingSettingRequest(contextPath.addSegment("depOnboardingSettings").addKeys(new NameValue(id.toString())));
    }

    public ImportedWindowsAutopilotDeviceIdentityCollectionRequest importedWindowsAutopilotDeviceIdentities() {
        return new ImportedWindowsAutopilotDeviceIdentityCollectionRequest(
                        contextPath.addSegment("importedWindowsAutopilotDeviceIdentities"));
    }

    public ImportedWindowsAutopilotDeviceIdentityRequest importedWindowsAutopilotDeviceIdentities(String id) {
        return new ImportedWindowsAutopilotDeviceIdentityRequest(contextPath.addSegment("importedWindowsAutopilotDeviceIdentities").addKeys(new NameValue(id.toString())));
    }

    public AppleUserInitiatedEnrollmentProfileCollectionRequest appleUserInitiatedEnrollmentProfiles() {
        return new AppleUserInitiatedEnrollmentProfileCollectionRequest(
                        contextPath.addSegment("appleUserInitiatedEnrollmentProfiles"));
    }

    public AppleUserInitiatedEnrollmentProfileRequest appleUserInitiatedEnrollmentProfiles(String id) {
        return new AppleUserInitiatedEnrollmentProfileRequest(contextPath.addSegment("appleUserInitiatedEnrollmentProfiles").addKeys(new NameValue(id.toString())));
    }

    public ManagementConditionCollectionRequest managementConditions() {
        return new ManagementConditionCollectionRequest(
                        contextPath.addSegment("managementConditions"));
    }

    public ManagementConditionRequest managementConditions(String id) {
        return new ManagementConditionRequest(contextPath.addSegment("managementConditions").addKeys(new NameValue(id.toString())));
    }

    public ManagementConditionStatementCollectionRequest managementConditionStatements() {
        return new ManagementConditionStatementCollectionRequest(
                        contextPath.addSegment("managementConditionStatements"));
    }

    public ManagementConditionStatementRequest managementConditionStatements(String id) {
        return new ManagementConditionStatementRequest(contextPath.addSegment("managementConditionStatements").addKeys(new NameValue(id.toString())));
    }

    public GroupPolicyObjectFileCollectionRequest groupPolicyObjectFiles() {
        return new GroupPolicyObjectFileCollectionRequest(
                        contextPath.addSegment("groupPolicyObjectFiles"));
    }

    public GroupPolicyObjectFileRequest groupPolicyObjectFiles(String id) {
        return new GroupPolicyObjectFileRequest(contextPath.addSegment("groupPolicyObjectFiles").addKeys(new NameValue(id.toString())));
    }

    public GroupPolicyMigrationReportCollectionRequest groupPolicyMigrationReports() {
        return new GroupPolicyMigrationReportCollectionRequest(
                        contextPath.addSegment("groupPolicyMigrationReports"));
    }

    public GroupPolicyMigrationReportRequest groupPolicyMigrationReports(String id) {
        return new GroupPolicyMigrationReportRequest(contextPath.addSegment("groupPolicyMigrationReports").addKeys(new NameValue(id.toString())));
    }

    public GroupPolicyConfigurationCollectionRequest groupPolicyConfigurations() {
        return new GroupPolicyConfigurationCollectionRequest(
                        contextPath.addSegment("groupPolicyConfigurations"));
    }

    public GroupPolicyConfigurationRequest groupPolicyConfigurations(String id) {
        return new GroupPolicyConfigurationRequest(contextPath.addSegment("groupPolicyConfigurations").addKeys(new NameValue(id.toString())));
    }

    public GroupPolicyCategoryCollectionRequest groupPolicyCategories() {
        return new GroupPolicyCategoryCollectionRequest(
                        contextPath.addSegment("groupPolicyCategories"));
    }

    public GroupPolicyCategoryRequest groupPolicyCategories(String id) {
        return new GroupPolicyCategoryRequest(contextPath.addSegment("groupPolicyCategories").addKeys(new NameValue(id.toString())));
    }

    public GroupPolicyDefinitionCollectionRequest groupPolicyDefinitions() {
        return new GroupPolicyDefinitionCollectionRequest(
                        contextPath.addSegment("groupPolicyDefinitions"));
    }

    public GroupPolicyDefinitionRequest groupPolicyDefinitions(String id) {
        return new GroupPolicyDefinitionRequest(contextPath.addSegment("groupPolicyDefinitions").addKeys(new NameValue(id.toString())));
    }

    public GroupPolicyDefinitionFileCollectionRequest groupPolicyDefinitionFiles() {
        return new GroupPolicyDefinitionFileCollectionRequest(
                        contextPath.addSegment("groupPolicyDefinitionFiles"));
    }

    public GroupPolicyDefinitionFileRequest groupPolicyDefinitionFiles(String id) {
        return new GroupPolicyDefinitionFileRequest(contextPath.addSegment("groupPolicyDefinitionFiles").addKeys(new NameValue(id.toString())));
    }

    public GroupPolicyUploadedDefinitionFileCollectionRequest groupPolicyUploadedDefinitionFiles() {
        return new GroupPolicyUploadedDefinitionFileCollectionRequest(
                        contextPath.addSegment("groupPolicyUploadedDefinitionFiles"));
    }

    public GroupPolicyUploadedDefinitionFileRequest groupPolicyUploadedDefinitionFiles(String id) {
        return new GroupPolicyUploadedDefinitionFileRequest(contextPath.addSegment("groupPolicyUploadedDefinitionFiles").addKeys(new NameValue(id.toString())));
    }

    public NotificationMessageTemplateCollectionRequest notificationMessageTemplates() {
        return new NotificationMessageTemplateCollectionRequest(
                        contextPath.addSegment("notificationMessageTemplates"));
    }

    public NotificationMessageTemplateRequest notificationMessageTemplates(String id) {
        return new NotificationMessageTemplateRequest(contextPath.addSegment("notificationMessageTemplates").addKeys(new NameValue(id.toString())));
    }

    public DeviceManagementDomainJoinConnectorCollectionRequest domainJoinConnectors() {
        return new DeviceManagementDomainJoinConnectorCollectionRequest(
                        contextPath.addSegment("domainJoinConnectors"));
    }

    public DeviceManagementDomainJoinConnectorRequest domainJoinConnectors(String id) {
        return new DeviceManagementDomainJoinConnectorRequest(contextPath.addSegment("domainJoinConnectors").addKeys(new NameValue(id.toString())));
    }

    public RoleDefinitionCollectionRequest roleDefinitions() {
        return new RoleDefinitionCollectionRequest(
                        contextPath.addSegment("roleDefinitions"));
    }

    public RoleDefinitionRequest roleDefinitions(String id) {
        return new RoleDefinitionRequest(contextPath.addSegment("roleDefinitions").addKeys(new NameValue(id.toString())));
    }

    public DeviceAndAppManagementRoleAssignmentCollectionRequest roleAssignments() {
        return new DeviceAndAppManagementRoleAssignmentCollectionRequest(
                        contextPath.addSegment("roleAssignments"));
    }

    public DeviceAndAppManagementRoleAssignmentRequest roleAssignments(String id) {
        return new DeviceAndAppManagementRoleAssignmentRequest(contextPath.addSegment("roleAssignments").addKeys(new NameValue(id.toString())));
    }

    public RoleScopeTagCollectionRequest roleScopeTags() {
        return new RoleScopeTagCollectionRequest(
                        contextPath.addSegment("roleScopeTags"));
    }

    public RoleScopeTagRequest roleScopeTags(String id) {
        return new RoleScopeTagRequest(contextPath.addSegment("roleScopeTags").addKeys(new NameValue(id.toString())));
    }

    public ResourceOperationCollectionRequest resourceOperations() {
        return new ResourceOperationCollectionRequest(
                        contextPath.addSegment("resourceOperations"));
    }

    public ResourceOperationRequest resourceOperations(String id) {
        return new ResourceOperationRequest(contextPath.addSegment("resourceOperations").addKeys(new NameValue(id.toString())));
    }

    public RemoteAssistancePartnerCollectionRequest remoteAssistancePartners() {
        return new RemoteAssistancePartnerCollectionRequest(
                        contextPath.addSegment("remoteAssistancePartners"));
    }

    public RemoteAssistancePartnerRequest remoteAssistancePartners(String id) {
        return new RemoteAssistancePartnerRequest(contextPath.addSegment("remoteAssistancePartners").addKeys(new NameValue(id.toString())));
    }

    public DeviceManagementReportsRequest reports() {
        return new DeviceManagementReportsRequest(contextPath.addSegment("reports"));
    }

    public TelecomExpenseManagementPartnerCollectionRequest telecomExpenseManagementPartners() {
        return new TelecomExpenseManagementPartnerCollectionRequest(
                        contextPath.addSegment("telecomExpenseManagementPartners"));
    }

    public TelecomExpenseManagementPartnerRequest telecomExpenseManagementPartners(String id) {
        return new TelecomExpenseManagementPartnerRequest(contextPath.addSegment("telecomExpenseManagementPartners").addKeys(new NameValue(id.toString())));
    }

    public EmbeddedSIMActivationCodePoolCollectionRequest embeddedSIMActivationCodePools() {
        return new EmbeddedSIMActivationCodePoolCollectionRequest(
                        contextPath.addSegment("embeddedSIMActivationCodePools"));
    }

    public EmbeddedSIMActivationCodePoolRequest embeddedSIMActivationCodePools(String id) {
        return new EmbeddedSIMActivationCodePoolRequest(contextPath.addSegment("embeddedSIMActivationCodePools").addKeys(new NameValue(id.toString())));
    }

    public DeviceManagementTroubleshootingEventCollectionRequest troubleshootingEvents() {
        return new DeviceManagementTroubleshootingEventCollectionRequest(
                        contextPath.addSegment("troubleshootingEvents"));
    }

    public DeviceManagementTroubleshootingEventRequest troubleshootingEvents(String id) {
        return new DeviceManagementTroubleshootingEventRequest(contextPath.addSegment("troubleshootingEvents").addKeys(new NameValue(id.toString())));
    }

    public DeviceManagementAutopilotEventCollectionRequest autopilotEvents() {
        return new DeviceManagementAutopilotEventCollectionRequest(
                        contextPath.addSegment("autopilotEvents"));
    }

    public DeviceManagementAutopilotEventRequest autopilotEvents(String id) {
        return new DeviceManagementAutopilotEventRequest(contextPath.addSegment("autopilotEvents").addKeys(new NameValue(id.toString())));
    }

    public WindowsFeatureUpdateProfileCollectionRequest windowsFeatureUpdateProfiles() {
        return new WindowsFeatureUpdateProfileCollectionRequest(
                        contextPath.addSegment("windowsFeatureUpdateProfiles"));
    }

    public WindowsFeatureUpdateProfileRequest windowsFeatureUpdateProfiles(String id) {
        return new WindowsFeatureUpdateProfileRequest(contextPath.addSegment("windowsFeatureUpdateProfiles").addKeys(new NameValue(id.toString())));
    }

    public WindowsInformationProtectionAppLearningSummaryCollectionRequest windowsInformationProtectionAppLearningSummaries() {
        return new WindowsInformationProtectionAppLearningSummaryCollectionRequest(
                        contextPath.addSegment("windowsInformationProtectionAppLearningSummaries"));
    }

    public WindowsInformationProtectionAppLearningSummaryRequest windowsInformationProtectionAppLearningSummaries(String id) {
        return new WindowsInformationProtectionAppLearningSummaryRequest(contextPath.addSegment("windowsInformationProtectionAppLearningSummaries").addKeys(new NameValue(id.toString())));
    }

    public WindowsInformationProtectionNetworkLearningSummaryCollectionRequest windowsInformationProtectionNetworkLearningSummaries() {
        return new WindowsInformationProtectionNetworkLearningSummaryCollectionRequest(
                        contextPath.addSegment("windowsInformationProtectionNetworkLearningSummaries"));
    }

    public WindowsInformationProtectionNetworkLearningSummaryRequest windowsInformationProtectionNetworkLearningSummaries(String id) {
        return new WindowsInformationProtectionNetworkLearningSummaryRequest(contextPath.addSegment("windowsInformationProtectionNetworkLearningSummaries").addKeys(new NameValue(id.toString())));
    }

    public IntuneBrandingProfileCollectionRequest intuneBrandingProfiles() {
        return new IntuneBrandingProfileCollectionRequest(
                        contextPath.addSegment("intuneBrandingProfiles"));
    }

    public IntuneBrandingProfileRequest intuneBrandingProfiles(String id) {
        return new IntuneBrandingProfileRequest(contextPath.addSegment("intuneBrandingProfiles").addKeys(new NameValue(id.toString())));
    }

    public UserPFXCertificateCollectionRequest userPfxCertificates() {
        return new UserPFXCertificateCollectionRequest(
                        contextPath.addSegment("userPfxCertificates"));
    }

    public UserPFXCertificateRequest userPfxCertificates(String id) {
        return new UserPFXCertificateRequest(contextPath.addSegment("userPfxCertificates").addKeys(new NameValue(id.toString())));
    }

    @Action(name = "enableUnlicensedAdminstrators")
    @JsonIgnore
    public ActionRequestNoReturn enableUnlicensedAdminstrators() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.enableUnlicensedAdminstrators"), _parameters);
    }

    @Action(name = "enableLegacyPcManagement")
    @JsonIgnore
    public ActionRequestNoReturn enableLegacyPcManagement() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.enableLegacyPcManagement"), _parameters);
    }

    @Action(name = "enableAndroidDeviceAdministratorEnrollment")
    @JsonIgnore
    public ActionRequestNoReturn enableAndroidDeviceAdministratorEnrollment() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.enableAndroidDeviceAdministratorEnrollment"), _parameters);
    }

    @Action(name = "sendCustomNotificationToCompanyPortal")
    @JsonIgnore
    public ActionRequestNoReturn sendCustomNotificationToCompanyPortal(String notificationTitle, String notificationBody, List<String> groupsToNotify) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("notificationTitle", "Edm.String", Checks.checkIsAscii(notificationTitle))
            .put("notificationBody", "Edm.String", Checks.checkIsAscii(notificationBody))
            .put("groupsToNotify", "Collection(Edm.String)", Checks.checkIsAscii(groupsToNotify))
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.sendCustomNotificationToCompanyPortal"), _parameters);
    }

    @Function(name = "verifyWindowsEnrollmentAutoDiscovery")
    @JsonIgnore
    public FunctionRequestReturningNonCollection<Boolean> verifyWindowsEnrollmentAutoDiscovery(String domainName) {
        Preconditions.checkNotNull(domainName, "domainName cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("domainName", "Edm.String", Checks.checkIsAscii(domainName))
            .build();
        return new FunctionRequestReturningNonCollection<Boolean>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.verifyWindowsEnrollmentAutoDiscovery"), Boolean.class, _parameters, com.github.davidmoten.odata.client.internal.EdmSchemaInfo.INSTANCE);
    }

    @Function(name = "getComanagedDevicesSummary")
    @JsonIgnore
    public FunctionRequestReturningNonCollectionUnwrapped<ComanagedDevicesSummary> getComanagedDevicesSummary() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new FunctionRequestReturningNonCollectionUnwrapped<ComanagedDevicesSummary>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getComanagedDevicesSummary"), ComanagedDevicesSummary.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

    @Function(name = "getComanagementEligibleDevicesSummary")
    @JsonIgnore
    public FunctionRequestReturningNonCollectionUnwrapped<ComanagementEligibleDevicesSummary> getComanagementEligibleDevicesSummary() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new FunctionRequestReturningNonCollectionUnwrapped<ComanagementEligibleDevicesSummary>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getComanagementEligibleDevicesSummary"), ComanagementEligibleDevicesSummary.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

    @Function(name = "getEffectivePermissions")
    @JsonIgnore
    public CollectionPageNonEntityRequest<String> getEffectivePermissions() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return CollectionPageNonEntityRequest.forAction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getEffectivePermissions"), String.class, _parameters, com.github.davidmoten.odata.client.internal.EdmSchemaInfo.INSTANCE);
    }

    @Function(name = "getEffectivePermissions")
    @JsonIgnore
    public CollectionPageNonEntityRequest<RolePermission> getEffectivePermissions_Function(String scope) {
        Preconditions.checkNotNull(scope, "scope cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("scope", "Edm.String", Checks.checkIsAscii(scope))
            .build();
        return CollectionPageNonEntityRequest.forAction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getEffectivePermissions"), RolePermission.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

    @Function(name = "getRoleScopeTagsByResource")
    @JsonIgnore
    public CollectionPageNonEntityRequest<RoleScopeTag> getRoleScopeTagsByResource(String resource) {
        Preconditions.checkNotNull(resource, "resource cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("resource", "Edm.String", Checks.checkIsAscii(resource))
            .build();
        return CollectionPageNonEntityRequest.forAction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getRoleScopeTagsByResource"), RoleScopeTag.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

    @Function(name = "getRoleScopeTagsByIds")
    @JsonIgnore
    public CollectionPageNonEntityRequest<RoleScopeTag> getRoleScopeTagsByIds(List<String> ids) {
        Preconditions.checkNotNull(ids, "ids cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("ids", "Collection(Edm.String)", Checks.checkIsAscii(ids))
            .build();
        return CollectionPageNonEntityRequest.forAction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getRoleScopeTagsByIds"), RoleScopeTag.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

    @Function(name = "getAssignedRoleDetails")
    @JsonIgnore
    public FunctionRequestReturningNonCollectionUnwrapped<DeviceAndAppManagementAssignedRoleDetails> getAssignedRoleDetails() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new FunctionRequestReturningNonCollectionUnwrapped<DeviceAndAppManagementAssignedRoleDetails>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getAssignedRoleDetails"), DeviceAndAppManagementAssignedRoleDetails.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

    @Function(name = "scopedForResource")
    @JsonIgnore
    public FunctionRequestReturningNonCollection<Boolean> scopedForResource(String resource) {
        Preconditions.checkNotNull(resource, "resource cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("resource", "Edm.String", Checks.checkIsAscii(resource))
            .build();
        return new FunctionRequestReturningNonCollection<Boolean>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.scopedForResource"), Boolean.class, _parameters, com.github.davidmoten.odata.client.internal.EdmSchemaInfo.INSTANCE);
    }

}
