package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ActionRequestReturningNonCollection;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.util.List;
import java.util.Map;

import odata.msgraph.client.beta.entity.DeviceManagementReports;
import odata.msgraph.client.beta.entity.collection.request.DeviceManagementCachedReportConfigurationCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.DeviceManagementExportJobCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.DeviceManagementReportScheduleCollectionRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

@JsonIgnoreType
public class DeviceManagementReportsRequest extends EntityRequest<DeviceManagementReports> {

    public DeviceManagementReportsRequest(ContextPath contextPath) {
        super(DeviceManagementReports.class, contextPath, SchemaInfo.INSTANCE);
    }

    public DeviceManagementCachedReportConfigurationCollectionRequest cachedReportConfigurations() {
        return new DeviceManagementCachedReportConfigurationCollectionRequest(
                        contextPath.addSegment("cachedReportConfigurations"));
    }

    public DeviceManagementCachedReportConfigurationRequest cachedReportConfigurations(String id) {
        return new DeviceManagementCachedReportConfigurationRequest(contextPath.addSegment("cachedReportConfigurations").addKeys(new NameValue(id.toString())));
    }

    public DeviceManagementExportJobCollectionRequest exportJobs() {
        return new DeviceManagementExportJobCollectionRequest(
                        contextPath.addSegment("exportJobs"));
    }

    public DeviceManagementExportJobRequest exportJobs(String id) {
        return new DeviceManagementExportJobRequest(contextPath.addSegment("exportJobs").addKeys(new NameValue(id.toString())));
    }

    public DeviceManagementReportScheduleCollectionRequest reportSchedules() {
        return new DeviceManagementReportScheduleCollectionRequest(
                        contextPath.addSegment("reportSchedules"));
    }

    public DeviceManagementReportScheduleRequest reportSchedules(String id) {
        return new DeviceManagementReportScheduleRequest(contextPath.addSegment("reportSchedules").addKeys(new NameValue(id.toString())));
    }

    @Action(name = "getActiveMalwareReport")
    @JsonIgnore
    public ActionRequestReturningNonCollection<String> getActiveMalwareReport(String name, List<String> select, String search, List<String> groupBy, List<String> orderBy, Integer skip, Integer top, String sessionId, String filter) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("name", "Edm.String", Checks.checkIsAscii(name))
            .put("select", "Collection(Edm.String)", Checks.checkIsAscii(select))
            .put("search", "Edm.String", Checks.checkIsAscii(search))
            .put("groupBy", "Collection(Edm.String)", Checks.checkIsAscii(groupBy))
            .put("orderBy", "Collection(Edm.String)", Checks.checkIsAscii(orderBy))
            .put("skip", "Edm.Int32", skip)
            .put("top", "Edm.Int32", top)
            .put("sessionId", "Edm.String", Checks.checkIsAscii(sessionId))
            .put("filter", "Edm.String", Checks.checkIsAscii(filter))
            .build();
        return new ActionRequestReturningNonCollection<String>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getActiveMalwareReport"), String.class, _parameters, com.github.davidmoten.odata.client.internal.EdmSchemaInfo.INSTANCE);
    }

    @Action(name = "getDeviceNonComplianceReport")
    @JsonIgnore
    public ActionRequestReturningNonCollection<String> getDeviceNonComplianceReport(String name, List<String> select, String search, List<String> groupBy, List<String> orderBy, Integer skip, Integer top, String sessionId, String filter) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("name", "Edm.String", Checks.checkIsAscii(name))
            .put("select", "Collection(Edm.String)", Checks.checkIsAscii(select))
            .put("search", "Edm.String", Checks.checkIsAscii(search))
            .put("groupBy", "Collection(Edm.String)", Checks.checkIsAscii(groupBy))
            .put("orderBy", "Collection(Edm.String)", Checks.checkIsAscii(orderBy))
            .put("skip", "Edm.Int32", skip)
            .put("top", "Edm.Int32", top)
            .put("sessionId", "Edm.String", Checks.checkIsAscii(sessionId))
            .put("filter", "Edm.String", Checks.checkIsAscii(filter))
            .build();
        return new ActionRequestReturningNonCollection<String>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getDeviceNonComplianceReport"), String.class, _parameters, com.github.davidmoten.odata.client.internal.EdmSchemaInfo.INSTANCE);
    }

    @Action(name = "getPolicyNonComplianceReport")
    @JsonIgnore
    public ActionRequestReturningNonCollection<String> getPolicyNonComplianceReport(String name, List<String> select, String search, List<String> groupBy, List<String> orderBy, Integer skip, Integer top, String sessionId, String filter) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("name", "Edm.String", Checks.checkIsAscii(name))
            .put("select", "Collection(Edm.String)", Checks.checkIsAscii(select))
            .put("search", "Edm.String", Checks.checkIsAscii(search))
            .put("groupBy", "Collection(Edm.String)", Checks.checkIsAscii(groupBy))
            .put("orderBy", "Collection(Edm.String)", Checks.checkIsAscii(orderBy))
            .put("skip", "Edm.Int32", skip)
            .put("top", "Edm.Int32", top)
            .put("sessionId", "Edm.String", Checks.checkIsAscii(sessionId))
            .put("filter", "Edm.String", Checks.checkIsAscii(filter))
            .build();
        return new ActionRequestReturningNonCollection<String>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getPolicyNonComplianceReport"), String.class, _parameters, com.github.davidmoten.odata.client.internal.EdmSchemaInfo.INSTANCE);
    }

    @Action(name = "getPolicyNonComplianceMetadata")
    @JsonIgnore
    public ActionRequestReturningNonCollection<String> getPolicyNonComplianceMetadata(String name, List<String> select, String search, List<String> groupBy, List<String> orderBy, Integer skip, Integer top, String sessionId, String filter) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("name", "Edm.String", Checks.checkIsAscii(name))
            .put("select", "Collection(Edm.String)", Checks.checkIsAscii(select))
            .put("search", "Edm.String", Checks.checkIsAscii(search))
            .put("groupBy", "Collection(Edm.String)", Checks.checkIsAscii(groupBy))
            .put("orderBy", "Collection(Edm.String)", Checks.checkIsAscii(orderBy))
            .put("skip", "Edm.Int32", skip)
            .put("top", "Edm.Int32", top)
            .put("sessionId", "Edm.String", Checks.checkIsAscii(sessionId))
            .put("filter", "Edm.String", Checks.checkIsAscii(filter))
            .build();
        return new ActionRequestReturningNonCollection<String>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getPolicyNonComplianceMetadata"), String.class, _parameters, com.github.davidmoten.odata.client.internal.EdmSchemaInfo.INSTANCE);
    }

    @Action(name = "getPolicyNonComplianceSummaryReport")
    @JsonIgnore
    public ActionRequestReturningNonCollection<String> getPolicyNonComplianceSummaryReport(String name, List<String> select, String search, List<String> groupBy, List<String> orderBy, Integer skip, Integer top, String sessionId, String filter) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("name", "Edm.String", Checks.checkIsAscii(name))
            .put("select", "Collection(Edm.String)", Checks.checkIsAscii(select))
            .put("search", "Edm.String", Checks.checkIsAscii(search))
            .put("groupBy", "Collection(Edm.String)", Checks.checkIsAscii(groupBy))
            .put("orderBy", "Collection(Edm.String)", Checks.checkIsAscii(orderBy))
            .put("skip", "Edm.Int32", skip)
            .put("top", "Edm.Int32", top)
            .put("sessionId", "Edm.String", Checks.checkIsAscii(sessionId))
            .put("filter", "Edm.String", Checks.checkIsAscii(filter))
            .build();
        return new ActionRequestReturningNonCollection<String>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getPolicyNonComplianceSummaryReport"), String.class, _parameters, com.github.davidmoten.odata.client.internal.EdmSchemaInfo.INSTANCE);
    }

    @Action(name = "getSettingNonComplianceReport")
    @JsonIgnore
    public ActionRequestReturningNonCollection<String> getSettingNonComplianceReport(String name, List<String> select, String search, List<String> groupBy, List<String> orderBy, Integer skip, Integer top, String sessionId, String filter) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("name", "Edm.String", Checks.checkIsAscii(name))
            .put("select", "Collection(Edm.String)", Checks.checkIsAscii(select))
            .put("search", "Edm.String", Checks.checkIsAscii(search))
            .put("groupBy", "Collection(Edm.String)", Checks.checkIsAscii(groupBy))
            .put("orderBy", "Collection(Edm.String)", Checks.checkIsAscii(orderBy))
            .put("skip", "Edm.Int32", skip)
            .put("top", "Edm.Int32", top)
            .put("sessionId", "Edm.String", Checks.checkIsAscii(sessionId))
            .put("filter", "Edm.String", Checks.checkIsAscii(filter))
            .build();
        return new ActionRequestReturningNonCollection<String>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getSettingNonComplianceReport"), String.class, _parameters, com.github.davidmoten.odata.client.internal.EdmSchemaInfo.INSTANCE);
    }

    @Action(name = "getReportFilters")
    @JsonIgnore
    public ActionRequestReturningNonCollection<String> getReportFilters(String name, List<String> select, String search, List<String> groupBy, List<String> orderBy, Integer skip, Integer top, String sessionId, String filter) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("name", "Edm.String", Checks.checkIsAscii(name))
            .put("select", "Collection(Edm.String)", Checks.checkIsAscii(select))
            .put("search", "Edm.String", Checks.checkIsAscii(search))
            .put("groupBy", "Collection(Edm.String)", Checks.checkIsAscii(groupBy))
            .put("orderBy", "Collection(Edm.String)", Checks.checkIsAscii(orderBy))
            .put("skip", "Edm.Int32", skip)
            .put("top", "Edm.Int32", top)
            .put("sessionId", "Edm.String", Checks.checkIsAscii(sessionId))
            .put("filter", "Edm.String", Checks.checkIsAscii(filter))
            .build();
        return new ActionRequestReturningNonCollection<String>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getReportFilters"), String.class, _parameters, com.github.davidmoten.odata.client.internal.EdmSchemaInfo.INSTANCE);
    }

    @Action(name = "getHistoricalReport")
    @JsonIgnore
    public ActionRequestReturningNonCollection<String> getHistoricalReport(String name, List<String> select, String search, List<String> groupBy, List<String> orderBy, Integer skip, Integer top, String filter) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("name", "Edm.String", Checks.checkIsAscii(name))
            .put("select", "Collection(Edm.String)", Checks.checkIsAscii(select))
            .put("search", "Edm.String", Checks.checkIsAscii(search))
            .put("groupBy", "Collection(Edm.String)", Checks.checkIsAscii(groupBy))
            .put("orderBy", "Collection(Edm.String)", Checks.checkIsAscii(orderBy))
            .put("skip", "Edm.Int32", skip)
            .put("top", "Edm.Int32", top)
            .put("filter", "Edm.String", Checks.checkIsAscii(filter))
            .build();
        return new ActionRequestReturningNonCollection<String>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getHistoricalReport"), String.class, _parameters, com.github.davidmoten.odata.client.internal.EdmSchemaInfo.INSTANCE);
    }

    @Action(name = "getCachedReport")
    @JsonIgnore
    public ActionRequestReturningNonCollection<String> getCachedReport(String id, List<String> select, String search, List<String> groupBy, List<String> orderBy, Integer skip, Integer top) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("id", "Edm.String", Checks.checkIsAscii(id))
            .put("select", "Collection(Edm.String)", Checks.checkIsAscii(select))
            .put("search", "Edm.String", Checks.checkIsAscii(search))
            .put("groupBy", "Collection(Edm.String)", Checks.checkIsAscii(groupBy))
            .put("orderBy", "Collection(Edm.String)", Checks.checkIsAscii(orderBy))
            .put("skip", "Edm.Int32", skip)
            .put("top", "Edm.Int32", top)
            .build();
        return new ActionRequestReturningNonCollection<String>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getCachedReport"), String.class, _parameters, com.github.davidmoten.odata.client.internal.EdmSchemaInfo.INSTANCE);
    }

    @Action(name = "getWindowsUpdateAlertSummaryReport")
    @JsonIgnore
    public ActionRequestReturningNonCollection<String> getWindowsUpdateAlertSummaryReport(String name, List<String> select, String search, List<String> groupBy, List<String> orderBy, Integer skip, Integer top, String sessionId, String filter) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("name", "Edm.String", Checks.checkIsAscii(name))
            .put("select", "Collection(Edm.String)", Checks.checkIsAscii(select))
            .put("search", "Edm.String", Checks.checkIsAscii(search))
            .put("groupBy", "Collection(Edm.String)", Checks.checkIsAscii(groupBy))
            .put("orderBy", "Collection(Edm.String)", Checks.checkIsAscii(orderBy))
            .put("skip", "Edm.Int32", skip)
            .put("top", "Edm.Int32", top)
            .put("sessionId", "Edm.String", Checks.checkIsAscii(sessionId))
            .put("filter", "Edm.String", Checks.checkIsAscii(filter))
            .build();
        return new ActionRequestReturningNonCollection<String>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getWindowsUpdateAlertSummaryReport"), String.class, _parameters, com.github.davidmoten.odata.client.internal.EdmSchemaInfo.INSTANCE);
    }

    @Action(name = "getWindowsUpdateAlertsPerPolicyPerDeviceReport")
    @JsonIgnore
    public ActionRequestReturningNonCollection<String> getWindowsUpdateAlertsPerPolicyPerDeviceReport(String name, List<String> select, String search, List<String> groupBy, List<String> orderBy, Integer skip, Integer top, String sessionId, String filter) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("name", "Edm.String", Checks.checkIsAscii(name))
            .put("select", "Collection(Edm.String)", Checks.checkIsAscii(select))
            .put("search", "Edm.String", Checks.checkIsAscii(search))
            .put("groupBy", "Collection(Edm.String)", Checks.checkIsAscii(groupBy))
            .put("orderBy", "Collection(Edm.String)", Checks.checkIsAscii(orderBy))
            .put("skip", "Edm.Int32", skip)
            .put("top", "Edm.Int32", top)
            .put("sessionId", "Edm.String", Checks.checkIsAscii(sessionId))
            .put("filter", "Edm.String", Checks.checkIsAscii(filter))
            .build();
        return new ActionRequestReturningNonCollection<String>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getWindowsUpdateAlertsPerPolicyPerDeviceReport"), String.class, _parameters, com.github.davidmoten.odata.client.internal.EdmSchemaInfo.INSTANCE);
    }

}
