package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import odata.msgraph.client.beta.entity.DeviceManagementIntentSettingCategory;
import odata.msgraph.client.beta.entity.collection.request.DeviceManagementSettingInstanceCollectionRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

@JsonIgnoreType
public class DeviceManagementIntentSettingCategoryRequest extends EntityRequest<DeviceManagementIntentSettingCategory> {

    public DeviceManagementIntentSettingCategoryRequest(ContextPath contextPath) {
        super(DeviceManagementIntentSettingCategory.class, contextPath, SchemaInfo.INSTANCE);
    }

    public DeviceManagementSettingInstanceCollectionRequest settings() {
        return new DeviceManagementSettingInstanceCollectionRequest(
                        contextPath.addSegment("settings"));
    }

    public DeviceManagementSettingInstanceRequest settings(String id) {
        return new DeviceManagementSettingInstanceRequest(contextPath.addSegment("settings").addKeys(new NameValue(id.toString())));
    }

}
