package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;

import odata.msgraph.client.beta.entity.DeviceManagementExchangeOnPremisesPolicy;
import odata.msgraph.client.beta.schema.SchemaInfo;

@JsonIgnoreType
public class DeviceManagementExchangeOnPremisesPolicyRequest extends EntityRequest<DeviceManagementExchangeOnPremisesPolicy> {

    public DeviceManagementExchangeOnPremisesPolicyRequest(ContextPath contextPath) {
        super(DeviceManagementExchangeOnPremisesPolicy.class, contextPath, SchemaInfo.INSTANCE);
    }

    public OnPremisesConditionalAccessSettingsRequest conditionalAccessSettings() {
        return new OnPremisesConditionalAccessSettingsRequest(contextPath.addSegment("conditionalAccessSettings"));
    }

}
