package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.guavamini.Preconditions;
import com.github.davidmoten.odata.client.ActionRequestNoReturn;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.util.Map;

import odata.msgraph.client.beta.entity.DeviceManagementExchangeConnector;
import odata.msgraph.client.beta.enums.DeviceManagementExchangeConnectorSyncType;
import odata.msgraph.client.beta.schema.SchemaInfo;

@JsonIgnoreType
public class DeviceManagementExchangeConnectorRequest extends EntityRequest<DeviceManagementExchangeConnector> {

    public DeviceManagementExchangeConnectorRequest(ContextPath contextPath) {
        super(DeviceManagementExchangeConnector.class, contextPath, SchemaInfo.INSTANCE);
    }

    @Action(name = "sync")
    @JsonIgnore
    public ActionRequestNoReturn sync(DeviceManagementExchangeConnectorSyncType syncType) {
        Preconditions.checkNotNull(syncType, "syncType cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("syncType", "microsoft.graph.deviceManagementExchangeConnectorSyncType", syncType)
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.sync"), _parameters);
    }

}
